/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.key.publicly;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.ASnotifyKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmimePublicKey
extends ASnotifyKey<X509Certificate>
implements ISnotifyPublicKey<X509Certificate> {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmimePublicKey.class);
    private final X509Certificate certificate;

    public SnotifySmimePublicKey(X509Certificate certificate) {
        this(certificate, null);
    }

    public SnotifySmimePublicKey(X509Certificate certificate, String email) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.SMIME);
        this.certificate = certificate;
        if (certificate == null) {
            log.warn("Certificate key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (!SmimeUtil.isCertForPurpose(certificate, this.getKeyPurpose())) {
            log.debug("Certificate can not be used for encryption.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        try {
            if (email == null || SmimeUtil.isCertForEmail(certificate, email)) {
                certificate.checkValidity();
            } else {
                log.debug("Email <{}> does not match emails for certificate.", (Object)email);
                this.setKeyValidity(EKeyValidity.INVALID);
            }
        }
        catch (CertificateExpiredException e) {
            log.warn("Certificate with serial number {} is invalid because it expired at: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)certificate.getNotAfter());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateNotYetValidException e) {
            log.warn("Certificate with serial number {} is invalid because it only becomes valid at: {}", (Object)SmimeUtil.getSerialNumber(certificate), (Object)certificate.getNotBefore());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateException e) {
            log.error("Could not check that email <" + email + "> matches certificate with serial number " + SmimeUtil.getSerialNumber(certificate) + ".", (Throwable)e);
            this.setKeyValidity(EKeyValidity.ERROR);
        }
    }

    public SnotifySmimePublicKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SnotifySmimePublicKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.ENCRYPTION, ECryptographyType.SMIME);
        this.certificate = null;
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        if (this.certificate == null) {
            return null;
        }
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate getKey() {
        return this.certificate;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Public Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Certificate ID: ");
        builder.append(this.getKey() == null ? null : SmimeUtil.getSerialNumber(this.getKey()));
        return builder.toString();
    }
}

