/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.connector.LdapConnector;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpGlobalDirectoryLoader;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpKeyServerLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpGlobalDirectoryVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyServerVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPublicKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeLdapVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeP7bVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.RadioHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.ValueHandlerWrapper;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyStoreSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = 785321803711093501L;
    private static final Logger log = LoggerFactory.getLogger(UserKeyStoreSettingsServlet.class);
    private static final String SMIME_PUBLIC_KEYSTORE_LOCATION_ID = "smimePublicKeystoreLocation";
    private static final String SMIME_PUBLIC_KEYSTORE_TYPE_ID = "smimePublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSTORE_LOCATION_ID = "pgpPublicKeystoreLocation";
    private static final String PGP_PUBLIC_KEYSERVER_LOCATION_ID = "pgpPublicKeyserverLocation";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID = "allowPublicPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID = "allowPublicSmimeCertOverwrite";
    private static final String USE_SMIME_PUBLIC_USER_DIRECTORY_ID = "smimePublicUserDirectory";
    private static final String VERIFY_PGP_BUTTON_PARAM = "Verify-PGP";
    private static final String VERIFY_SMIME_BUTTON_PARAM = "Verify-SMIME";
    private static final String CLEAR_CACHE_PGP_BUTTON_PARAM = "Clear-Cache-PGP";
    private static final String CLEAR_CACHE_SMIME_PARAM = "Clear-Cache-SMIME";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Update-PGP";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Update-SMIME";
    private static final String DISPLAYED_TAB_KEY = "displayedTab";
    private static final String VERIFY_MESSAGE_KEY = "verifyMessageHtml";
    private static final String EXPIRE_KEYS_KEY = "expireKeys";

    public UserKeyStoreSettingsServlet() {
        super("user-key-store-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData();
        ValueHandlerWrapper wrapper = this.createValueHandlers();
        wrapper.read();
        renderData.put("valueHandlerProvider", wrapper);
        this.renderInput(resp, renderData);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData();
        ValueHandlerWrapper wrapper = this.createValueHandlers();
        wrapper.receive(req);
        renderData.put("valueHandlerProvider", wrapper);
        if (req.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put("showUpdated", true);
            if (this.isLocationChanged(wrapper)) {
                this.clearCache();
                renderData.put(EXPIRE_KEYS_KEY, true);
            }
            this.storeSettings(wrapper);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put("showUpdated", true);
            if (this.isLocationChanged(wrapper)) {
                renderData.put(EXPIRE_KEYS_KEY, true);
                this.clearCache();
            }
            this.storeSettings(wrapper);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(VERIFY_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put(VERIFY_MESSAGE_KEY, this.verifySettings(wrapper));
            this.renderInput(resp, renderData);
        } else if (req.getParameter(VERIFY_SMIME_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put(VERIFY_MESSAGE_KEY, this.verifySettings(wrapper));
            this.renderInput(resp, renderData);
        } else if (req.getParameter(CLEAR_CACHE_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put(EXPIRE_KEYS_KEY, true);
            this.clearCache();
            this.renderInput(resp, renderData);
        } else if (req.getParameter(CLEAR_CACHE_SMIME_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put(EXPIRE_KEYS_KEY, true);
            this.clearCache();
            this.renderInput(resp, renderData);
        } else {
            resp.sendError(400);
        }
    }

    private void storeSettings(ValueHandlerWrapper wrapper) {
        wrapper.store();
    }

    private String verifySettings(IValueHandlerProvider provider) {
        String pgpKeyServerLocation;
        String pgpKeyStoreLocation;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        String smimeKeyStoreLocation = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimeKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_TYPE_ID);
            statusList.addAll(this.verifySmimePublicKeystore(smimeKeyStoreLocation, keyStoreType));
        }
        if (((Boolean)provider.getValue(USE_SMIME_PUBLIC_USER_DIRECTORY_ID)).booleanValue()) {
            statusList.addAll(this.verifySmimePublicUserDirectory());
        }
        if (StringUtils.isNotBlank((String)(pgpKeyStoreLocation = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_LOCATION_ID)))) {
            statusList.addAll(this.verifyPgpPublicKeystore(pgpKeyStoreLocation));
        }
        if (StringUtils.isNotBlank((String)(pgpKeyServerLocation = (String)provider.getValue(PGP_PUBLIC_KEYSERVER_LOCATION_ID)))) {
            statusList.addAll(this.verifyPgpPublicKeyserver(pgpKeyServerLocation));
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        return builder.toString();
    }

    private List<VerificationStatus> verifySmimePublicKeystore(String keyStoreLocation, String keyStoreType) {
        log.info("Verifying S/MIME public key store at location: {}", (Object)keyStoreLocation);
        String email = this.getUser().getEmail();
        ISnotifyI18n i18n = this.getI18n();
        switch (keyStoreType) {
            case "BKS": {
                SmimeKeyStoreVerification ksVerification = new SmimeKeyStoreVerification(keyStoreLocation, keyStoreType, i18n);
                if (email != null) {
                    ksVerification.getEmails().add(email);
                }
                return ksVerification.verify();
            }
            case "PKCS7": {
                SmimeP7bVerification p7bVerification = new SmimeP7bVerification(keyStoreLocation, i18n);
                if (email != null) {
                    p7bVerification.getEmails().add(email);
                }
                return p7bVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)keyStoreType);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.message", (Object)keyStoreType);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpPublicKeystore(String keyStoreLocation) {
        log.info("Verifying PGP public key store at location: {}", (Object)keyStoreLocation);
        String email = this.getUser().getEmail();
        ISnotifyI18n i18n = this.getI18n();
        PgpPublicKeyStoreVerification verification = new PgpPublicKeyStoreVerification(keyStoreLocation, i18n);
        verification.setEmail(email);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPublicKeyserver(String keyServerLocation) {
        AKeySourceVerification verification;
        URI uri;
        log.info("Verifying PGP public key server at location: {}", (Object)keyServerLocation);
        String email = this.getUser().getEmail();
        ISnotifyI18n i18n = this.getI18n();
        try {
            uri = new URI(keyServerLocation);
        }
        catch (URISyntaxException e) {
            log.debug("Given url was not valid: {}", (Object)keyServerLocation);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalidUrl.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalid.message", (Object)keyServerLocation);
            return Collections.singletonList(status);
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("ldap")) {
            LdapConnector connector = new LdapConnector();
            connector.setHost(uri.getHost());
            connector.setPort(uri.getPort());
            connector.setSsl(uri.getScheme().equals("ldaps"));
            PgpGlobalDirectoryLoader loader = new PgpGlobalDirectoryLoader(connector, email);
            verification = new PgpGlobalDirectoryVerification(loader, i18n);
        } else {
            PgpKeyServerLoader loader = new PgpKeyServerLoader(keyServerLocation, email);
            verification = new PgpKeyServerVerification(loader, i18n);
        }
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicUserDirectory() {
        AtlassianLdapConnector connector;
        Directory directory;
        log.info("Verifying user directory for S/MIME public certificates.");
        ISnotifyI18n i18n = this.getI18n();
        DetailedUser user = this.getDetailedUser(this.getUser().getActualUser());
        if (user == null) {
            log.debug("Could not find a detailed user for user: {}", (Object)this.getUser().getActualUser());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.message", (Object)this.getUser().getDisplayName());
            return Collections.singletonList(status);
        }
        String directoryName = user.getDirectoryName();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with name " + directoryName + ". Error message: " + e.getMessage(), (Throwable)e);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.message", (Object)directoryName, (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is probably not an LDAP directory.", (Object)directory.getName());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.message", (Object)directory.getName(), (Object)userName);
            return Collections.singletonList(status);
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP connection from directory " + directory.getName() + ". Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, userFilter);
        loader.setKeySource(EKeySource.LDAP);
        loader.setEmail(user.getEmailAddress());
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, i18n);
        verification.setUserNotFoundStatus(EVerificationStatus.ERROR);
        return verification.verify();
    }

    private DetailedUser getDetailedUser(ApplicationUser user) {
        if (user instanceof DetailedUser) {
            return (DetailedUser)user;
        }
        UserAdminService service = (UserAdminService)ComponentLocator.getComponent(UserAdminService.class);
        return service.getUserDetails(user);
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    private ValueHandlerWrapper createValueHandlers() {
        ValueHandlerWrapper wrapper = new ValueHandlerWrapper();
        wrapper.add(new InputHandler(SMIME_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION));
        wrapper.add(new RadioHandler(SMIME_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_TYPE));
        wrapper.add(new CheckBoxHandler(USE_SMIME_PUBLIC_USER_DIRECTORY_ID, this.getAppProps(), EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME));
        wrapper.add(new CheckBoxHandler(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        wrapper.add(new InputHandler(PGP_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_LOCATION));
        wrapper.add(new InputHandler(PGP_PUBLIC_KEYSERVER_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSERVER_PGP_LOCATION));
        wrapper.add(new CheckBoxHandler(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        return wrapper;
    }

    private boolean isLocationChanged(IValueHandlerProvider provider) {
        if (this.isLocationChanged(EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION, provider.getValueHandler(SMIME_PUBLIC_KEYSTORE_LOCATION_ID))) {
            return true;
        }
        if (this.isLocationChanged(EProperty.PUBLIC_KEYSTORE_SMIME_TYPE, provider.getValueHandler(SMIME_PUBLIC_KEYSTORE_TYPE_ID))) {
            return true;
        }
        if (this.isLocationChanged(EProperty.PUBLIC_KEYSTORE_PGP_LOCATION, provider.getValueHandler(PGP_PUBLIC_KEYSTORE_LOCATION_ID))) {
            return true;
        }
        return this.isLocationChanged(EProperty.PUBLIC_KEYSERVER_PGP_LOCATION, provider.getValueHandler(PGP_PUBLIC_KEYSERVER_LOCATION_ID));
    }

    private boolean isLocationChanged(EProperty prop, IValueHandler<?> handler) {
        String oldLocation = this.getAppProps().getString(prop);
        Object value = handler.getValue();
        return this.isChanged(oldLocation, value == null ? null : value.toString());
    }

    private boolean isChanged(String oldStr, String newStr) {
        return !StringUtils.equalsIgnoreCase((String)StringUtils.stripToNull((String)oldStr), (String)StringUtils.stripToNull((String)newStr));
    }

    public boolean isSmimeSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.SMIME) {
            return true;
        }
        if (cryptoType == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.PGP) {
            return true;
        }
        if (cryptoType == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }
}

