/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Exception;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLTaggedObject;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    final int tagNo;
    final boolean explicit;
    final ASN1Encodable obj;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            return ASN1TaggedObject.getInstance(obj.getObject());
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public ASN1TaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        if (null == obj) {
            throw new NullPointerException("'obj' cannot be null");
        }
        this.tagNo = tagNo;
        this.explicit = explicit || obj instanceof ASN1Choice;
        this.obj = obj;
    }

    boolean asn1Equals(ASN1Primitive other) {
        ASN1Primitive p2;
        if (!(other instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject that = (ASN1TaggedObject)other;
        if (this.tagNo != that.tagNo || this.explicit != that.explicit) {
            return false;
        }
        ASN1Primitive p1 = this.obj.toASN1Primitive();
        return p1 == (p2 = that.obj.toASN1Primitive()) || p1.asn1Equals(p2);
    }

    public int hashCode() {
        return this.tagNo ^ (this.explicit ? 15 : 240) ^ this.obj.toASN1Primitive().hashCode();
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return false;
    }

    public ASN1Primitive getObject() {
        return this.obj.toASN1Primitive();
    }

    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        switch (tag) {
            case 17: {
                return ASN1Set.getInstance(this, isExplicit).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, isExplicit).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, isExplicit).parser();
            }
        }
        if (isExplicit) {
            return this.getObject();
        }
        throw new ASN1Exception("implicit tagging not implemented for tag: " + tag);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    ASN1Primitive toDERObject() {
        return new DERTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    ASN1Primitive toDLObject() {
        return new DLTaggedObject(this.explicit, this.tagNo, this.obj);
    }

    abstract void encode(ASN1OutputStream var1, boolean var2) throws IOException;

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

