/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1GeneralizedTime;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIFreeText;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmp.PKIHeader;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.GeneralName;

public class PKIHeaderBuilder {
    private ASN1Integer pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private ASN1GeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    public PKIHeaderBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this(new ASN1Integer(pvno), sender, recipient);
    }

    private PKIHeaderBuilder(ASN1Integer pvno, GeneralName sender, GeneralName recipient) {
        this.pvno = pvno;
        this.sender = sender;
        this.recipient = recipient;
    }

    public PKIHeaderBuilder setMessageTime(ASN1GeneralizedTime time) {
        this.messageTime = time;
        return this;
    }

    public PKIHeaderBuilder setProtectionAlg(AlgorithmIdentifier aid) {
        this.protectionAlg = aid;
        return this;
    }

    public PKIHeaderBuilder setSenderKID(byte[] kid) {
        return this.setSenderKID(kid == null ? null : new DEROctetString(kid));
    }

    public PKIHeaderBuilder setSenderKID(ASN1OctetString kid) {
        this.senderKID = kid;
        return this;
    }

    public PKIHeaderBuilder setRecipKID(byte[] kid) {
        return this.setRecipKID(kid == null ? null : new DEROctetString(kid));
    }

    public PKIHeaderBuilder setRecipKID(DEROctetString kid) {
        this.recipKID = kid;
        return this;
    }

    public PKIHeaderBuilder setTransactionID(byte[] tid) {
        return this.setTransactionID(tid == null ? null : new DEROctetString(tid));
    }

    public PKIHeaderBuilder setTransactionID(ASN1OctetString tid) {
        this.transactionID = tid;
        return this;
    }

    public PKIHeaderBuilder setSenderNonce(byte[] nonce) {
        return this.setSenderNonce(nonce == null ? null : new DEROctetString(nonce));
    }

    public PKIHeaderBuilder setSenderNonce(ASN1OctetString nonce) {
        this.senderNonce = nonce;
        return this;
    }

    public PKIHeaderBuilder setRecipNonce(byte[] nonce) {
        return this.setRecipNonce(nonce == null ? null : new DEROctetString(nonce));
    }

    public PKIHeaderBuilder setRecipNonce(ASN1OctetString nonce) {
        this.recipNonce = nonce;
        return this;
    }

    public PKIHeaderBuilder setFreeText(PKIFreeText text) {
        this.freeText = text;
        return this;
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue genInfo) {
        return this.setGeneralInfo(PKIHeaderBuilder.makeGeneralInfoSeq(genInfo));
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue[] genInfos) {
        return this.setGeneralInfo(PKIHeaderBuilder.makeGeneralInfoSeq(genInfos));
    }

    public PKIHeaderBuilder setGeneralInfo(ASN1Sequence seqOfInfoTypeAndValue) {
        this.generalInfo = seqOfInfoTypeAndValue;
        return this;
    }

    private static ASN1Sequence makeGeneralInfoSeq(InfoTypeAndValue generalInfo) {
        return new DERSequence(generalInfo);
    }

    private static ASN1Sequence makeGeneralInfoSeq(InfoTypeAndValue[] generalInfos) {
        DERSequence genInfoSeq = null;
        if (generalInfos != null) {
            genInfoSeq = new DERSequence(generalInfos);
        }
        return genInfoSeq;
    }

    public PKIHeader build() {
        ASN1EncodableVector v = new ASN1EncodableVector(12);
        v.add(this.pvno);
        v.add(this.sender);
        v.add(this.recipient);
        this.addOptional(v, 0, this.messageTime);
        this.addOptional(v, 1, this.protectionAlg);
        this.addOptional(v, 2, this.senderKID);
        this.addOptional(v, 3, this.recipKID);
        this.addOptional(v, 4, this.transactionID);
        this.addOptional(v, 5, this.senderNonce);
        this.addOptional(v, 6, this.recipNonce);
        this.addOptional(v, 7, this.freeText);
        this.addOptional(v, 8, this.generalInfo);
        this.messageTime = null;
        this.protectionAlg = null;
        this.senderKID = null;
        this.recipKID = null;
        this.transactionID = null;
        this.senderNonce = null;
        this.recipNonce = null;
        this.freeText = null;
        this.generalInfo = null;
        return PKIHeader.getInstance(new DERSequence(v));
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(true, tagNo, obj));
        }
    }
}

