/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.OnePassSignaturePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private int signatureType;
    private PGPContentVerifier verifier;
    private byte lastb;
    private OutputStream sigOut;

    private static OnePassSignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof OnePassSignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (OnePassSignaturePacket)packet;
    }

    PGPOnePassSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPOnePassSignature.cast(pIn.readPacket()));
    }

    PGPOnePassSignature(OnePassSignaturePacket sigPack) throws PGPException {
        this.sigPack = sigPack;
        this.signatureType = sigPack.getSignatureType();
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        PGPContentVerifierBuilder verifierBuilder = verifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = verifierBuilder.build(pubKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public void update(byte b) {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(b);
            }
            this.lastb = b;
        } else {
            this.byteUpdate(b);
        }
    }

    public void update(byte[] bytes) {
        if (this.signatureType == 1) {
            for (int i = 0; i != bytes.length; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.blockUpdate(bytes, 0, bytes.length);
        }
    }

    public void update(byte[] bytes, int off, int length) {
        if (this.signatureType == 1) {
            int finish = off + length;
            for (int i = off; i != finish; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.blockUpdate(bytes, off, length);
        }
    }

    private void byteUpdate(byte b) {
        try {
            this.sigOut.write(b);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    private void blockUpdate(byte[] block, int off, int len) {
        try {
            this.sigOut.write(block, off, len);
        }
        catch (IOException e) {
            throw new PGPRuntimeOperationException(e.getMessage(), e);
        }
    }

    public boolean verify(PGPSignature pgpSig) throws PGPException {
        try {
            this.sigOut.write(pgpSig.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException("unable to add trailer: " + e.getMessage(), e);
        }
        return this.verifier.verify(pgpSig.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.sigPack);
    }
}

