/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA1Digest;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;

class SHA1PGPDigestCalculator
implements PGPDigestCalculator {
    private Digest digest = new SHA1Digest();

    SHA1PGPDigestCalculator() {
    }

    public int getAlgorithm() {
        return 2;
    }

    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    public byte[] getDigest() {
        byte[] d = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(d, 0);
        return d;
    }

    public void reset() {
        this.digest.reset();
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes, 0, bytes.length);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

