/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.gui.key.info.AKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import org.apache.commons.lang.StringUtils;

public class PgpPublicKeyInfoBuilder
extends AKeyInfoBuilder {
    private final PGPPublicKeyRing ring;
    private final Long keyId;

    public PgpPublicKeyInfoBuilder(PGPPublicKeyRing ring, Long keyId, ISnotifyI18n i18n) throws PGPException {
        super(i18n);
        this.ring = ring;
        this.keyId = keyId;
        if (ring == null) {
            throw new IllegalArgumentException("Key ring must not be null.");
        }
        if (keyId != null && ring.getPublicKey(keyId) == null) {
            throw new PGPException("No public key found for ID: " + PgpUtil.getPrettyId(keyId));
        }
    }

    public PgpPublicKeyInfoBuilder(byte[] key, long keyId, ISnotifyI18n i18n) throws IOException, PGPException {
        this(PgpUtil.loadPublicKey(new ByteArrayInputStream(key)), (Long)keyId, i18n);
    }

    @Override
    public String build(IKeyValueStyle style) {
        PGPPublicKey encKey;
        StringBuilder builder = new StringBuilder(1000);
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.type"), this.getI18n().getText("net.savignano.snotify.info-builder.pgp.type"), "type-pgp"));
        if (this.getUser() != null && this.getUserProps() != null) {
            Long timeStamp = this.getUserProps().getLong(EProperty.EMAIL_PGP_TIME_STAMP, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadTime"), timeStamp == null ? "N/A" : this.getI18n().formatDateTime(new Date(timeStamp), FormatStyle.MEDIUM), "key-uploadTime"));
            EKeySource keySource = this.getUserProps().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadBy"), keySource == null ? "N/A" : this.getI18n().getText("net.savignano.snotify.upload-key-source." + keySource.name()), "key-uploadBy"));
        }
        PGPPublicKey masterKey = this.ring.getPublicKey();
        PGPPublicKey pGPPublicKey = encKey = this.keyId == null ? null : this.ring.getPublicKey(this.keyId);
        if (encKey == null) {
            encKey = masterKey;
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.valid"), this.getI18n().formatDateTime(masterKey.getCreationTime(), FormatStyle.MEDIUM), "key-valid"));
        if (encKey.getValidSeconds() == 0L) {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires"), this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires.never"), "key-expires"));
        } else {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires"), this.getI18n().formatDateTime(new Date(encKey.getCreationTime().getTime() + encKey.getValidSeconds() * 1000L), FormatStyle.MEDIUM), "key-expires"));
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.id"), PgpUtil.getPrettyId(masterKey), "key-id"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.fingerprint"), this.getPrettyPrintFingerprint(masterKey.getFingerprint()), "key-fingerprint"));
        if (encKey.getKeyID() != masterKey.getKeyID()) {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.encKeyId"), PgpUtil.getPrettyId(encKey), "key-encryption"));
        }
        ArrayList<String> users = new ArrayList<String>();
        Iterator<String> iter = masterKey.getUserIDs();
        while (iter.hasNext()) {
            users.add(iter.next());
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.users"), StringUtils.join(users, (String)", "), "key-users"));
        return builder.toString();
    }

    private String getPrettyPrintFingerprint(byte[] fingerprint) {
        String full = Hex.toHexString(fingerprint).toUpperCase();
        StringBuilder builder = new StringBuilder(full.length() + full.length() / 4);
        int space = -1;
        for (char c : full.toCharArray()) {
            if (++space == 4) {
                builder.append(' ');
                space = 0;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

