/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.atlassian.gui.APluginListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BitbucketPluginListener
extends APluginListener {
    private static final Logger log = LoggerFactory.getLogger(BitbucketPluginListener.class);
    @Inject
    @ComponentImport
    private ApplicationPropertiesService appProperties;
    @Inject
    @ComponentImport
    private MailService service;

    @Override
    protected void setMailerVersion() {
        this.getAppProps().setString(EProperty.MAILER_VERSION, null);
        if (!this.service.isHostConfigured()) {
            log.warn("Cannot check if correct mailer library for S/Notify is installed. Please configure an outgoing SMTP mail server, so S/Notify can automatically check if the GUI plugin and Mailer library are compatible with each other.");
            return;
        }
        log.debug("Sending internal email to check S/Notify mailer library version.");
        this.service.submit(this.createMsg());
        try {
            for (int i = 0; i < 10; ++i) {
                log.debug("Sleeping for 500ms, waiting for S/Notify mailer library version detection to happen.");
                Thread.sleep(500L);
                if (!this.getAppProps().hasKey(EProperty.MAILER_VERSION)) continue;
                log.debug("S/Notify mailer library version detection successfully finished.");
                break;
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private MailMessage createMsg() {
        MailMessage.Builder builder = new MailMessage.Builder();
        builder.to(new String[]{this.appProperties.getServerEmailAddress()});
        builder.subject("S/Notify test email");
        builder.text("This is a test email of S/Notify. Should you have received this, S/Notify mailer library is not properly configured or missing entirely.");
        builder.header("X-SNotify-Do-Not-Send", Boolean.TRUE.toString());
        return builder.build();
    }

    @Override
    protected boolean checkSignature() {
        NormalizedVersion bitbucketVersion = new NormalizedVersion(this.appProperties.getBuildVersion());
        if (bitbucketVersion.isLowerThan(new NormalizedVersion(7, 14))) {
            log.warn("Bitbucket version {} detected. Skipping signature check.", (Object)bitbucketVersion);
            return true;
        }
        return super.checkSignature();
    }

    @Override
    protected void createCache() {
    }

    @Override
    protected void destroyCache() {
    }
}

