/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.atlassian.gui.templates.IAdminTemplate;
import net.savignano.snotify.bitbucket.gui.servlet.SnotifyServlet;

public class AdminSettingsServlet
extends SnotifyServlet
implements IAdminTemplate {
    private static final long serialVersionUID = 8821514405597304115L;
    @Inject
    @ComponentImport
    private ApplicationPropertiesService appPropService;
    @Inject
    @ComponentImport
    private PermissionService permissionService;

    public AdminSettingsServlet(String templateFolder) {
        super(templateFolder);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        super.doGet(req, resp);
    }

    @Override
    protected void redirectLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirect = resp.encodeRedirectURL(req.getContextPath() + "/login?next=" + req.getServletPath() + "&permission=admin");
        resp.sendRedirect(redirect);
    }

    public boolean hasAdminRights() {
        return this.permissionService.hasGlobalPermission(Permission.ADMIN);
    }

    @Override
    public String getGetStartedLink() {
        String baseUrl = this.appPropService.getBaseUrl().toString();
        return baseUrl + "/plugins/servlet/snotify/installation-guide";
    }

    @Override
    public boolean isMailerLibPresent() {
        return this.getMailerVersion() != null;
    }

    @Override
    public boolean isVersionMatch() {
        if (!this.getAppProps().getBoolean(EProperty.DEV_MODE)) {
            return IAdminTemplate.super.isVersionMatch();
        }
        NormalizedVersion guiVersion = new NormalizedVersion(this.getGuiVersion());
        NormalizedVersion mailerVersion = new NormalizedVersion(this.getMailerVersion());
        return guiVersion.equals(mailerVersion);
    }

    @Override
    public boolean isMailServerPresent() {
        return this.appPropService.getMailHostConfiguration() != null;
    }

    @Override
    public String getGuiVersion() {
        return this.getAppProps().getString(EProperty.GUI_VERSION);
    }

    @Override
    public String getMailerVersion() {
        return this.getAppProps().getString(EProperty.MAILER_VERSION);
    }

    @Override
    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public boolean isLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }
}

