/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.examples.ExampleUtils;

public class CreateLargeEncryptedMail {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage: CreateLargeEncryptedMail pkcs12Keystore password inputFile");
            System.exit(0);
        }
        KeyStore ks = KeyStore.getInstance("PKCS12", "SAVIGNANO-BC");
        String keyAlias = ExampleUtils.findKeyAlias(ks, args[0], args[1].toCharArray());
        Certificate[] chain = ks.getCertificateChain(keyAlias);
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        gen.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator((X509Certificate)chain[0]).setProvider("BC"));
        MimeBodyPart msg = new MimeBodyPart();
        msg.setDataHandler(new DataHandler(new FileDataSource(new File(args[2]))));
        msg.setHeader("Content-Type", "application/octet-stream");
        msg.setHeader("Content-Transfer-Encoding", "binary");
        MimeBodyPart mp = gen.generate(msg, new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC).setProvider("SAVIGNANO-BC").build());
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance(props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom(fromUser);
        body.setRecipient(Message.RecipientType.TO, toUser);
        body.setSubject("example encrypted message");
        body.setContent(mp.getContent(), mp.getContentType());
        body.saveChanges();
        body.writeTo(new FileOutputStream("encrypted.message"));
    }
}

