/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.CipherInputStream;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper helper) {
        this.helper = helper;
    }

    String getDigestName(int hashAlgorithm) throws PGPException {
        switch (hashAlgorithm) {
            case 2: {
                return "SHA-1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + hashAlgorithm);
    }

    MessageDigest createDigest(int algorithm) throws GeneralSecurityException, PGPException {
        MessageDigest dig;
        String digestName = this.getDigestName(algorithm);
        try {
            dig = this.helper.createMessageDigest(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            if (algorithm >= 8 && algorithm <= 11) {
                dig = this.helper.createMessageDigest("SHA" + digestName.substring(4));
            }
            throw e;
        }
        return dig;
    }

    KeyFactory createKeyFactory(String algorithm) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(algorithm);
    }

    public KeyAgreement createKeyAgreement(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyAgreement(algorithm);
    }

    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        return this.helper.createKeyPairGenerator(algorithm);
    }

    PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            final Cipher c = this.createStreamCipher(encAlgorithm, withIntegrityPacket);
            if (withIntegrityPacket) {
                byte[] iv = new byte[c.getBlockSize()];
                c.init(2, (Key)secretKey, new IvParameterSpec(iv));
            } else {
                c.init(2, secretKey);
            }
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream in) {
                    return new CipherInputStream(in, c);
                }

                public int getBlockSize() {
                    return c.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    Cipher createStreamCipher(int encAlgorithm, boolean withIntegrityPacket) throws PGPException {
        String mode = withIntegrityPacket ? "CFB" : "OpenPGPCFB";
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm) + "/" + mode + "/NoPadding";
        return this.createCipher(cName);
    }

    Cipher createCipher(String cipherName) throws PGPException {
        try {
            return this.helper.createCipher(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    Cipher createPublicKeyCipher(int encAlgorithm) throws PGPException {
        switch (encAlgorithm) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 22: {
                throw new PGPException("Can't use EDDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + encAlgorithm);
    }

    Cipher createKeyWrapper(int encAlgorithm) throws PGPException {
        try {
            switch (encAlgorithm) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
                case 11: 
                case 12: 
                case 13: {
                    return this.helper.createCipher("CamelliaWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + encAlgorithm);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create cipher: " + e.getMessage(), e);
        }
    }

    private Signature createSignature(String cipherName) throws PGPException {
        try {
            return this.helper.createSignature(cipherName);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("cannot create signature: " + e.getMessage(), e);
        }
    }

    public Signature createSignature(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        String encAlg;
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                encAlg = "RSA";
                break;
            }
            case 17: {
                encAlg = "DSA";
                break;
            }
            case 16: 
            case 20: {
                encAlg = "ElGamal";
                break;
            }
            case 19: {
                encAlg = "ECDSA";
                break;
            }
            case 22: {
                return this.createSignature("Ed25519");
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + keyAlgorithm);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(hashAlgorithm) + "with" + encAlg);
    }

    public AlgorithmParameters createAlgorithmParameters(String algorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.helper.createAlgorithmParameters(algorithm);
    }
}

