/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.format.FormatStyle;
import java.util.Date;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.gui.key.info.AKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.X500Name;
import net.savignano.thirdparty.org.bouncycastle.asn1.x500.style.BCStyle;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.apache.commons.lang.StringUtils;

public class SmimeCertInfoBuilder
extends AKeyInfoBuilder {
    private final X509Certificate certificate;

    public SmimeCertInfoBuilder(X509Certificate certificate, ISnotifyI18n i18n) {
        super(i18n);
        this.certificate = certificate;
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate must not be null.");
        }
    }

    public SmimeCertInfoBuilder(byte[] certificate, ISnotifyI18n i18n) throws CertificateException {
        this((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate)), i18n);
    }

    @Override
    public String build(IKeyValueStyle style) throws CertificateException {
        JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(this.certificate);
        X500Name issuer = certHolder.getIssuer();
        X500Name subject = certHolder.getSubject();
        StringBuilder builder = new StringBuilder(500);
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.type"), this.getI18n().getText("net.savignano.snotify.info-builder.smime.type"), "type-smime"));
        if (this.getUser() != null && this.getUserProps() != null) {
            Long timeStamp = this.getUserProps().getLong(EProperty.EMAIL_SMIME_TIME_STAMP, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadTime"), timeStamp == null ? "N/A" : this.getI18n().formatDateTime(new Date(timeStamp), FormatStyle.MEDIUM), "key-uploadTime"));
            EKeySource keySource = this.getUserProps().getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadBy"), keySource == null ? "N/A" : this.getI18n().getText("net.savignano.snotify.upload-key-source." + keySource.name()), "key-uploadBy"));
        }
        String owner = this.getRDNValue(subject, BCStyle.CN);
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.valid"), this.getI18n().formatDateTime(this.certificate.getNotBefore(), FormatStyle.MEDIUM), "cert-valid"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.expires"), this.getI18n().formatDateTime(this.certificate.getNotAfter(), FormatStyle.MEDIUM), "cert-expires"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.serialNumber"), SmimeUtil.getSerialNumber(this.certificate), "cert-serial-number"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.owner"), owner == null ? "-" : owner, "cert-subject-owner"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.email"), this.getEmails(), "cert-subject-email"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.issuer"), this.getRDNValue(issuer, BCStyle.CN) + " (" + this.getIssuerEmails() + ")", "cert-issuer"));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.smime.cert.algorithm"), this.certificate.getSigAlgName(), "cert-algorithm"));
        return builder.toString();
    }

    private String getEmails() throws CertificateException {
        Object[] emails = SmimeUtil.getEmails(this.certificate);
        if (emails.length == 0) {
            return "-";
        }
        return StringUtils.join((Object[])emails, (String)", ");
    }

    private String getIssuerEmails() throws CertificateException {
        Object[] emails = SmimeUtil.getIssuerEmails(this.certificate);
        if (emails.length == 0) {
            return "N/A";
        }
        return StringUtils.join((Object[])emails, (String)", ");
    }

    private String getRDNValue(X500Name name, ASN1ObjectIdentifier identifier) {
        return SmimeUtil.getRDNValue(name, identifier);
    }
}

