/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import net.savignano.snotify.atlassian.common.ASnotifyAppProperties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class SnotifyAppProperties
extends ASnotifyAppProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyAppProperties.class);
    @ComponentImport
    private PluginSettingsFactory factory;
    private PluginSettings props;

    @Override
    protected String getString(String key) {
        String value;
        try {
            value = (String)this.getProps().get(key);
        }
        catch (Exception e) {
            log.error("Property exception loading application property " + key + ".", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.trace("App property \"{}\" is considered null.", (Object)key);
            return null;
        }
        log.trace("App property \"{}\" is: {}", (Object)key, (Object)value);
        return value;
    }

    @Override
    protected void setString(String key, String value) {
        try {
            log.trace("Setting app property \"{}\" to: {}", (Object)key, (Object)value);
            if (value == null) {
                this.getProps().remove(key);
            } else {
                this.getProps().put(key, (Object)value);
            }
            if (log.isTraceEnabled()) {
                String newValue = (String)this.getProps().get(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of app property \"{}\" failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, value, newValue});
                }
            }
        }
        catch (Exception e) {
            log.error("Property exception setting application property " + key + ".", (Throwable)e);
        }
    }

    private PluginSettings getProps() {
        if (this.props == null) {
            if (this.factory == null) {
                log.trace("Injection of PluginSettingsFactory failed. Loading manually.");
                this.factory = (PluginSettingsFactory)ComponentLocator.getComponent(PluginSettingsFactory.class);
            }
            this.props = this.factory.createGlobalSettings();
        }
        return this.props;
    }
}

