/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

