/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.dvcs;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSProcessableByteArray;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.dvcs.DVCSException;
import net.savignano.thirdparty.org.bouncycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator signedDataGen) {
        this.signedDataGen = signedDataGen;
    }

    public CMSSignedData build(DVCSMessage message) throws DVCSException {
        try {
            byte[] encapsulatedData = message.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(message.getContentType(), encapsulatedData), true);
        }
        catch (CMSException e) {
            throw new DVCSException("Could not sign DVCS request", e);
        }
        catch (IOException e) {
            throw new DVCSException("Could not encode DVCS request", e);
        }
    }
}

