/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.TrustPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Iterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKeyRing
extends PGPKeyRing
implements Iterable<PGPPublicKey> {
    List keys;

    public PGPPublicKeyRing(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    private static List checkKeys(List keys) {
        ArrayList<PGPPublicKey> rv = new ArrayList<PGPPublicKey>(keys.size());
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)keys.get(i);
            if (i == 0) {
                if (!k.isMasterKey()) {
                    throw new IllegalArgumentException("key 0 must be a master key");
                }
            } else if (k.isMasterKey()) {
                throw new IllegalArgumentException("key 0 can be only master key");
            }
            rv.add(k);
        }
        return rv;
    }

    public PGPPublicKeyRing(List pubKeys) {
        this.keys = PGPPublicKeyRing.checkKeys(pubKeys);
    }

    public PGPPublicKeyRing(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException {
        this.keys = new ArrayList();
        BCPGInputStream pIn = PGPPublicKeyRing.wrap(in);
        int initialTag = pIn.nextPacketTag();
        if (initialTag != 6 && initialTag != 14) {
            throw new IOException("public key ring doesn't start with public key tag: tag 0x" + Integer.toHexString(initialTag));
        }
        PublicKeyPacket pubPk = PGPPublicKeyRing.readPublicKeyPacket(pIn);
        TrustPacket trustPk = PGPPublicKeyRing.readOptionalTrustPacket(pIn);
        List keySigs = PGPPublicKeyRing.readSignaturesAndTrust(pIn);
        ArrayList ids = new ArrayList();
        ArrayList idTrusts = new ArrayList();
        ArrayList idSigs = new ArrayList();
        PGPPublicKeyRing.readUserIDs(pIn, ids, idTrusts, idSigs);
        try {
            this.keys.add(new PGPPublicKey(pubPk, trustPk, keySigs, ids, idTrusts, idSigs, fingerPrintCalculator));
            while (pIn.nextPacketTag() == 14) {
                this.keys.add(PGPPublicKeyRing.readSubkey(pIn, fingerPrintCalculator));
            }
        }
        catch (PGPException e) {
            throw new IOException("processing exception: " + e.toString());
        }
    }

    @Override
    public PGPPublicKey getPublicKey() {
        return (PGPPublicKey)this.keys.get(0);
    }

    @Override
    public PGPPublicKey getPublicKey(long keyID) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (keyID != k.getKeyID()) continue;
            return k;
        }
        return null;
    }

    @Override
    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            if (!Arrays.areEqual(fingerprint, k.getFingerprint())) continue;
            return k;
        }
        return null;
    }

    @Override
    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            Iterator<PGPSignature> sigIt = k.getSignaturesForKeyID(keyID);
            if (!sigIt.hasNext()) continue;
            keysWithSigs.add(k);
        }
        return keysWithSigs.iterator();
    }

    @Override
    public Iterator<PGPPublicKey> getPublicKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    @Override
    public Iterator<PGPPublicKey> iterator() {
        return this.getPublicKeys();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    @Override
    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPPublicKey k = (PGPPublicKey)this.keys.get(i);
            k.encode(outStream, forTransfer);
        }
    }

    public static PGPPublicKeyRing insertPublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>(pubRing.keys);
        boolean found = false;
        boolean masterFound = false;
        for (int i = 0; i != keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() == pubKey.getKeyID()) {
                found = true;
                keys.set(i, pubKey);
            }
            if (!key.isMasterKey()) continue;
            masterFound = true;
        }
        if (!found) {
            if (pubKey.isMasterKey()) {
                if (masterFound) {
                    throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
                }
                keys.add(0, pubKey);
            } else {
                keys.add(pubKey);
            }
        }
        return new PGPPublicKeyRing(keys);
    }

    public static PGPPublicKeyRing removePublicKey(PGPPublicKeyRing pubRing, PGPPublicKey pubKey) {
        ArrayList keys = new ArrayList(pubRing.keys);
        boolean found = false;
        for (int i = 0; i < keys.size(); ++i) {
            PGPPublicKey key = (PGPPublicKey)keys.get(i);
            if (key.getKeyID() != pubKey.getKeyID()) continue;
            found = true;
            keys.remove(i);
        }
        if (!found) {
            return null;
        }
        return new PGPPublicKeyRing(keys);
    }

    static PublicKeyPacket readPublicKeyPacket(BCPGInputStream in) throws IOException {
        Packet packet = in.readPacket();
        if (!(packet instanceof PublicKeyPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (PublicKeyPacket)packet;
    }

    static PGPPublicKey readSubkey(BCPGInputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        PublicKeyPacket pk = PGPPublicKeyRing.readPublicKeyPacket(in);
        TrustPacket kTrust = PGPPublicKeyRing.readOptionalTrustPacket(in);
        List sigList = PGPPublicKeyRing.readSignaturesAndTrust(in);
        return new PGPPublicKey(pk, kTrust, sigList, fingerPrintCalculator);
    }
}

