/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.Composer;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.util.io.Streams;

public class HSSPublicKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int l, LMSPublicKeyParameters lmsPublicKey) {
        super(false);
        this.l = l;
        this.lmsPublicKey = lmsPublicKey;
    }

    public static HSSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int L = ((DataInputStream)src).readInt();
            LMSPublicKeyParameters lmsPublicKey = LMSPublicKeyParameters.getInstance(src);
            return new HSSPublicKeyParameters(L, lmsPublicKey);
        }
        if (src instanceof byte[]) {
            InputStream in = null;
            try {
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(in);
                return hSSPublicKeyParameters;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (src instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSSPublicKeyParameters publicKey = (HSSPublicKeyParameters)o;
        if (this.l != publicKey.l) {
            return false;
        }
        return this.lmsPublicKey.equals(publicKey.lmsPublicKey);
    }

    public int hashCode() {
        int result = this.l;
        result = 31 * result + this.lmsPublicKey.hashCode();
        return result;
    }

    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }
}

