/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.MessageSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSSignature;

public class HSSSigner
implements MessageSigner {
    private HSSPrivateKeyParameters privKey;
    private HSSPublicKeyParameters pubKey;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (HSSPrivateKeyParameters)param;
        } else {
            this.pubKey = (HSSPublicKeyParameters)param;
        }
    }

    public byte[] generateSignature(byte[] message) {
        try {
            return HSS.generateSignature(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return HSS.verifySignature(this.pubKey, HSSSignature.getInstance(signature, this.pubKey.getL()), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

