/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.NullDigest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.MessageSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSSigner;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms.BCLMSPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.lms.DigestUtil;

public class LMSSignatureSpi
extends Signature {
    private Digest digest;
    private MessageSigner signer;
    private SecureRandom random;

    protected LMSSignatureSpi(String algorithm) {
        super(algorithm);
    }

    protected LMSSignatureSpi(String sigName, Digest digest) {
        super(sigName);
        this.digest = digest;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof BCLMSPublicKey)) {
            throw new InvalidKeyException("unknown public key passed to XMSS");
        }
        CipherParameters param = ((BCLMSPublicKey)publicKey).getKeyParams();
        this.digest.reset();
        this.signer = param instanceof LMSPublicKeyParameters ? new LMSSigner() : new HSSSigner();
        this.signer.init(false, param);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.random = random;
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof BCLMSPrivateKey)) {
            throw new InvalidKeyException("unknown private key passed to XMSS");
        }
        CipherParameters param = ((BCLMSPrivateKey)privateKey).getKeyParams();
        this.signer = param instanceof HSSPrivateKeyParameters ? new HSSSigner() : new LMSSigner();
        this.digest.reset();
        this.signer.init(true, param);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.digest.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.digest.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        try {
            byte[] sig = this.signer.generateSignature(hash);
            return sig;
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw new SignatureException(e.getMessage(), e);
            }
            throw new SignatureException(e.toString(), e);
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = DigestUtil.getDigestResult(this.digest);
        return this.signer.verifySignature(hash, sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class generic
    extends LMSSignatureSpi {
        public generic() {
            super("LMS", new NullDigest());
        }
    }
}

