/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.connector;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnector {
    private static final Logger log = LoggerFactory.getLogger(LdapConnector.class);
    private String host;
    private int port = -1;
    private String dn;
    private String filter;
    private boolean ssl;
    private String loginUser;
    private char[] loginPassword;
    private DirContext context;

    public void connect() throws NamingException, URISyntaxException {
        this.connect(null);
    }

    public void connect(Map<String, String> envMap) throws NamingException, URISyntaxException {
        this.disconnect();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        URI url = this.getUri();
        log.debug("Connecting to LDAP URL: {}", (Object)url);
        env.put("java.naming.provider.url", url.toString());
        if (this.isSsl()) {
            log.debug("Using SSL for LDAP connection.");
            env.put("java.naming.security.protocol", "ssl");
        } else {
            log.debug("Not using SSL for LDAP connection.");
            env.put("java.naming.security.protocol", "none");
        }
        if (StringUtils.isBlank((String)this.getLoginUser()) || this.getLoginPassword() == null || this.getLoginPassword().length == 0) {
            log.debug("Using anonymous login for LDAP.");
            env.put("java.naming.security.authentication", "none");
        } else {
            log.debug("Using simple login for LDAP with user: {}", (Object)this.getLoginUser());
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.getLoginUser());
            env.put("java.naming.security.credentials", new String(this.getLoginPassword()));
        }
        log.trace("Using additional parameters: {}", envMap);
        if (envMap != null) {
            env.putAll(envMap);
        }
        this.setContext(new InitialDirContext(env));
    }

    public void disconnect() {
        this.setContext(null);
    }

    public DirContext getContext() {
        return this.context;
    }

    protected void setContext(DirContext context) {
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.context = context;
    }

    public URI getUri() throws URISyntaxException {
        String protocol = this.isSsl() ? "ldaps" : "ldap";
        return new URI(protocol, null, this.getHost(), this.getPort(), null, null, null);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String loginUser) {
        this.loginUser = loginUser;
    }

    public char[] getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(char[] loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String applyFilter(String additionalFilter) {
        if (additionalFilter == null) {
            return this.getFilter();
        }
        if (this.getFilter() == null) {
            return additionalFilter;
        }
        if (additionalFilter.startsWith("(") && additionalFilter.endsWith(")")) {
            return "(&" + this.getFilter() + additionalFilter + ")";
        }
        return "(&" + this.getFilter() + "(" + additionalFilter + "))";
    }

    public String toString() {
        return "LdapConnector [host=" + this.host + ", port=" + this.getPort() + ", dn=" + this.dn + ", loginUser=" + this.getLoginUser() + ", loginPassword=" + (this.getLoginPassword() == null ? null : "*****") + ", filter=" + this.getFilter() + "]";
    }
}

