/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import com.atlassian.cache.Cache;
import java.io.ByteArrayInputStream;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;

public class PgpCacheLoader
extends AKeyLoader<SnotifyPgpPublicKey> {
    private final Cache<String, byte[]> cache;
    private final String email;

    public PgpCacheLoader(Cache<String, byte[]> cache, String email) {
        this.cache = cache;
        this.email = email;
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    public void clear() {
        this.cache.remove((Object)this.email);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpPublicKey loadInternalKey() throws Exception {
        byte[] ring = (byte[])this.cache.get((Object)this.email);
        return ring == null ? this.getValidityKey(EKeyValidity.NOT_FOUND) : new SnotifyPgpPublicKey(PgpUtil.loadPublicKey(new ByteArrayInputStream(ring)), this.email);
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, this.getKeySource());
    }
}

