/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpDecryptionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;

public class PgpDecryptionKeyStoreLoader
extends AKeyLoader<SnotifyPgpDecryptionKey> {
    private final PGPSecretKeyRingCollection keyRings;
    private final char[] password;

    public PgpDecryptionKeyStoreLoader(PGPSecretKeyRingCollection keyStore, char[] password) {
        this.keyRings = keyStore;
        this.password = password;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
    }

    @Override
    protected SnotifyPgpDecryptionKey loadInternalKey() throws Exception {
        SnotifyPgpDecryptionKey key = new SnotifyPgpDecryptionKey(this.keyRings, this.password);
        key.setKeySource(this.getKeySource());
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected SnotifyPgpDecryptionKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpDecryptionKey(validity, this.getKeySource());
    }

    public PGPSecretKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String toString() {
        return "PgpDecryptionKeyStoreLoader [keyStore=" + this.keyRings + ", password=*****]";
    }
}

