/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import com.atlassian.cache.Cache;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;

public class SmimeCacheLoader
extends AKeyLoader<SnotifySmimePublicKey> {
    private final Cache<String, X509Certificate> cache;
    private final String email;

    public SmimeCacheLoader(Cache<String, X509Certificate> cache, String email) {
        this.cache = cache;
        this.email = email;
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("Email must not be null.");
        }
    }

    public void clear() {
        this.cache.remove((Object)this.email);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SnotifySmimePublicKey loadInternalKey() throws Exception {
        X509Certificate cert = (X509Certificate)this.cache.get((Object)this.email);
        return cert == null ? this.getValidityKey(EKeyValidity.NOT_FOUND) : new SnotifySmimePublicKey(cert, this.email);
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }
}

