/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.info.InfoData;
import net.savignano.snotify.atlassian.common.security.access.AKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.KeyStoreContentFetcher;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeCertificateKeyStoreLoader
extends AKeyLoader<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeCertificateKeyStoreLoader.class);
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyStore keyStore;
    private final String email;

    public SmimeCertificateKeyStoreLoader(KeyStore keyStore, String email) {
        this.keyStore = keyStore;
        this.email = email;
    }

    @Override
    protected SnotifySmimePublicKey loadInternalKey() throws Exception {
        SnotifySmimePublicKey key;
        if (this.keyStore == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (this.email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        log.info("Looking up S/MIME certificate for email <{}> in public key store.", (Object)this.getEmail());
        X509Certificate certificate = SmimeUtil.getValidCertForEmail(this.getKeyStore(), this.getEmail(), EKeyPurpose.ENCRYPTION);
        if (certificate != null) {
            log.info("Found valid S/MIME certificate for email <{}> in public key store.", (Object)this.getEmail());
            log.trace("Found certificate: {}", (Object)certificate);
            this.getInfoDataManager().send(new InfoData(202, this.getEmail()));
            SnotifySmimePublicKey key2 = new SnotifySmimePublicKey(certificate, this.getEmail());
            key2.setKeySource(this.getKeySource());
            return key2;
        }
        try {
            KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(this.getKeyStore());
            certificate = fetcher.getCertFor(SmimeUtil.createPredicateForEmail(this.getEmail())).orElseGet(() -> null);
        }
        catch (KeyStoreException e) {
            log.warn("Could not load certificate from public key store for email <" + this.getEmail() + ">.", (Throwable)e);
            this.getInfoDataManager().send(new InfoData(102, e));
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found no valid S/MIME certificate for email <{}> in public key store.", (Object)this.getEmail());
        log.trace("Found certificate: {}", (Object)certificate);
        if (certificate != null) {
            this.getInfoDataManager().send(new InfoData(202, this.getEmail()));
            key = new SnotifySmimePublicKey(certificate);
            key.setKeySource(this.getKeySource());
            return key;
        }
        this.getInfoDataManager().send(new InfoData(203, this.getEmail()));
        key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        return key;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "SmimeCertificateKeyStoreLoader [keyStore=" + this.keyStore + ", email=" + this.email + "]";
    }
}

