/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import org.apache.commons.lang.StringUtils;

public class VerificationStatusBuilder {
    private final ISnotifyI18n i18n;
    private String title;
    private String subTitle;
    private String message;
    private EVerificationStatus status;

    public VerificationStatusBuilder(ISnotifyI18n i18n) {
        this.i18n = i18n;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    public ISnotifyI18n getI18n() {
        return this.i18n;
    }

    public void status(EVerificationStatus status) {
        this.status = status;
    }

    public void success() {
        this.status(EVerificationStatus.SUCCESS);
    }

    public void info() {
        this.status(EVerificationStatus.INFO);
    }

    public void warning() {
        this.status(EVerificationStatus.WARNING);
    }

    public void error() {
        this.status(EVerificationStatus.ERROR);
    }

    public void title(String key, Object ... values) {
        this.title = this.i18n.getText(key, values);
    }

    public void subTitle(String key, Object ... values) {
        this.subTitle = this.i18n.getText(key, values);
    }

    public void message(String key, Object ... values) {
        this.message = this.i18n.getText(key, values);
    }

    public VerificationStatus build() {
        VerificationStatus verStatus = new VerificationStatus();
        verStatus.status = this.status;
        verStatus.message = this.message;
        verStatus.title = StringUtils.isNotBlank((String)this.subTitle) ? this.title + ": " + this.subTitle : this.title;
        return verStatus;
    }
}

