/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.Address;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketUser
implements IUser<ApplicationUser> {
    private static final Logger log = LoggerFactory.getLogger(BitbucketUser.class);
    private final ApplicationUser user;

    public static final BitbucketUser lookupUser(Address address) {
        return BitbucketUser.lookupUser(MessageUtil.getEmail(address));
    }

    public static final BitbucketUser lookupUser(String email) {
        List<BitbucketUser> users = BitbucketUser.lookupUsers(email);
        switch (users.size()) {
            case 0: {
                log.info("No user found for email: {}", (Object)email);
                return null;
            }
            case 1: {
                return users.get(0);
            }
        }
        log.warn("Multiple users found for email <{}>. First user found is used, but this can be unpredictable: {}", (Object)email, users);
        return users.get(0);
    }

    public static final List<BitbucketUser> lookupUsers(Address address) {
        return BitbucketUser.lookupUsers(MessageUtil.getEmail(address));
    }

    public static final List<BitbucketUser> lookupUsers(String email) {
        if (email == null) {
            return Collections.emptyList();
        }
        ArrayList<BitbucketUser> users = new ArrayList<BitbucketUser>();
        UserService service = (UserService)ComponentLocator.getComponent(UserService.class);
        UserSearchRequest userSearchReq = new UserSearchRequest.Builder().filter(email).build();
        PageRequestImpl pageReq = new PageRequestImpl(0, 10);
        BitbucketUser.fill(service, userSearchReq, (PageRequest)pageReq, email, users);
        log.debug("Found users for email <{}>: {}", (Object)email, users);
        return users;
    }

    private static final void fill(UserService service, UserSearchRequest userSearchReq, PageRequest pageReq, String email, List<BitbucketUser> users) {
        Page page = service.search(userSearchReq, pageReq);
        for (ApplicationUser user : page.getValues()) {
            if (!email.equalsIgnoreCase(user.getEmailAddress())) continue;
            if (user.isActive()) {
                users.add(new BitbucketUser(user));
                continue;
            }
            log.info("User {} is inactive. It will not be considered for email encryption.", (Object)user);
        }
        if (!page.getIsLastPage()) {
            BitbucketUser.fill(service, userSearchReq, page.getNextPageRequest(), email, users);
        }
    }

    public BitbucketUser(ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        this.user = user;
    }

    @Override
    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    @Override
    public String getEmail() {
        return this.user.getEmailAddress();
    }

    @Override
    public ApplicationUser getActualUser() {
        return this.user;
    }

    public String toString() {
        return this.user.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitbucketUser other = (BitbucketUser)obj;
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

