/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.S2K;

public class SymmetricKeyEncSessionPacket
extends ContainedPacket {
    private int version;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] secKeyData;

    public SymmetricKeyEncSessionPacket(BCPGInputStream in) throws IOException {
        this.version = in.read();
        this.encAlgorithm = in.read();
        this.s2k = new S2K(in);
        this.secKeyData = in.readAll();
    }

    public SymmetricKeyEncSessionPacket(int encAlgorithm, S2K s2k, byte[] secKeyData) {
        this.version = 4;
        this.encAlgorithm = encAlgorithm;
        this.s2k = s2k;
        this.secKeyData = secKeyData;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] getSecKeyData() {
        return this.secKeyData;
    }

    public int getVersion() {
        return this.version;
    }

    public void encode(BCPGOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write(this.encAlgorithm);
        pOut.writeObject(this.s2k);
        if (this.secKeyData != null && this.secKeyData.length > 0) {
            pOut.write(this.secKeyData);
        }
        pOut.close();
        out.writePacket(3, bOut.toByteArray(), true);
    }
}

