/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Security;
import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.NotationData;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class DirectKeySignature {
    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (args.length == 1) {
            PGPPublicKeyRing ring = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey key = ring.getPublicKey();
            Iterator iter = key.getSignaturesOfType(31);
            while (iter.hasNext()) {
                PGPSignature sig = (PGPSignature)iter.next();
                System.out.println("Signature date is: " + sig.getHashedSubPackets().getSignatureCreationTime());
                NotationData[] data = sig.getHashedSubPackets().getNotationDataOccurrences();
                for (int i = 0; i < data.length; ++i) {
                    System.out.println("Found Notation named '" + data[i].getNotationName() + "' with content '" + data[i].getNotationValue() + "'.");
                }
            }
        } else if (args.length == 5) {
            PGPPublicKeyRing sRing;
            PGPSecretKeyRing secRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String secretKeyPass = args[1];
            PGPPublicKeyRing ring = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(args[2])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String notationName = args[3];
            String notationValue = args[4];
            ring = sRing = new PGPPublicKeyRing(new ByteArrayInputStream(DirectKeySignature.signPublicKey(secRing.getSecretKey(), secretKeyPass, ring.getPublicKey(), notationName, notationValue)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            ArmoredOutputStream out = new ArmoredOutputStream(new FileOutputStream("SignedKey.asc"));
            sRing.encode(out);
            out.flush();
            out.close();
        } else {
            System.err.println("usage: DirectKeySignature secretKeyFile secretKeyPass publicKeyFile(key to be signed) NotationName NotationValue");
            System.err.println("or: DirectKeySignature signedPublicKeyFile");
        }
    }

    private static byte[] signPublicKey(PGPSecretKey secretKey, String secretKeyPass, PGPPublicKey keyToBeSigned, String notationName, String notationValue) throws Exception {
        PGPPrivateKey pgpPrivKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("SAVIGNANO-BC").build(secretKeyPass.toCharArray()));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 2).setProvider("SAVIGNANO-BC"));
        sGen.init(31, pgpPrivKey);
        PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
        boolean isHumanReadable = true;
        spGen.setNotationData(true, isHumanReadable, notationName, notationValue);
        PGPSignatureSubpacketVector packetVector = spGen.generate();
        sGen.setHashedSubpackets(packetVector);
        return PGPPublicKey.addCertification(keyToBeSigned, sGen.generate()).getEncoded();
    }
}

