/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;

public class NTRUEncryptionPrivateKeyParameters
extends NTRUEncryptionKeyParameters {
    public Polynomial t;
    public IntegerPolynomial fp;
    public IntegerPolynomial h;

    public NTRUEncryptionPrivateKeyParameters(IntegerPolynomial h, Polynomial t, IntegerPolynomial fp, NTRUEncryptionParameters params) {
        super(true, params);
        this.h = h;
        this.t = t;
        this.fp = fp;
    }

    public NTRUEncryptionPrivateKeyParameters(byte[] b, NTRUEncryptionParameters params) throws IOException {
        this(new ByteArrayInputStream(b), params);
    }

    public NTRUEncryptionPrivateKeyParameters(InputStream is, NTRUEncryptionParameters params) throws IOException {
        super(true, params);
        if (params.polyType == 1) {
            int N = params.N;
            int df1 = params.df1;
            int df2 = params.df2;
            int df3Ones = params.df3;
            int df3NegOnes = params.fastFp ? params.df3 : params.df3 - 1;
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            this.t = ProductFormPolynomial.fromBinary(is, N, df1, df2, df3Ones, df3NegOnes);
        } else {
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            IntegerPolynomial fInt = IntegerPolynomial.fromBinary3Tight(is, params.N);
            this.t = params.sparse ? new SparseTernaryPolynomial(fInt) : new DenseTernaryPolynomial(fInt);
        }
        this.init();
    }

    private void init() {
        if (this.params.fastFp) {
            this.fp = new IntegerPolynomial(this.params.N);
            this.fp.coeffs[0] = 1;
        } else {
            this.fp = this.t.toIntegerPolynomial().invertF3();
        }
    }

    public byte[] getEncoded() {
        byte[] hBytes = this.h.toBinary(this.params.q);
        byte[] tBytes = this.t instanceof ProductFormPolynomial ? ((ProductFormPolynomial)this.t).toBinary() : this.t.toIntegerPolynomial().toBinary3Tight();
        byte[] res = new byte[hBytes.length + tBytes.length];
        System.arraycopy(hBytes, 0, res, 0, hBytes.length);
        System.arraycopy(tBytes, 0, res, hBytes.length, tBytes.length);
        return res;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
        result = 31 * result + (this.h == null ? 0 : this.h.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUEncryptionPrivateKeyParameters)) {
            return false;
        }
        NTRUEncryptionPrivateKeyParameters other = (NTRUEncryptionPrivateKeyParameters)obj;
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.t == null ? other.t != null : !this.t.equals(other.t)) {
            return false;
        }
        return this.h.equals(other.h);
    }
}

