/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSMTPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.XMSSPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.Composer;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.Utils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;

public class SubjectPublicKeyInfoFactory {
    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws IOException {
        if (publicKey instanceof QTESLAPublicKeyParameters) {
            QTESLAPublicKeyParameters keyParams = (QTESLAPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = Utils.qTeslaLookupAlgID(keyParams.getSecurityCategory());
            return new SubjectPublicKeyInfo(algorithmIdentifier, keyParams.getPublicData());
        }
        if (publicKey instanceof SPHINCSPublicKeyParameters) {
            SPHINCSPublicKeyParameters params = (SPHINCSPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.sphincs256, new SPHINCS256KeyParams(Utils.sphincs256LookupTreeAlgID(params.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getKeyData());
        }
        if (publicKey instanceof NHPublicKeyParameters) {
            NHPublicKeyParameters params = (NHPublicKeyParameters)publicKey;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            return new SubjectPublicKeyInfo(algorithmIdentifier, params.getPubData());
        }
        if (publicKey instanceof LMSPublicKeyParameters) {
            LMSPublicKeyParameters params = (LMSPublicKeyParameters)publicKey;
            byte[] encoding = Composer.compose().u32str(1).bytes(params).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(encoding));
        }
        if (publicKey instanceof HSSPublicKeyParameters) {
            HSSPublicKeyParameters params = (HSSPublicKeyParameters)publicKey;
            byte[] encoding = Composer.compose().u32str(params.getL()).bytes(params).build();
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig);
            return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(encoding));
        }
        if (publicKey instanceof XMSSPublicKeyParameters) {
            XMSSPublicKeyParameters keyParams = (XMSSPublicKeyParameters)publicKey;
            byte[] publicSeed = keyParams.getPublicSeed();
            byte[] root = keyParams.getRoot();
            byte[] keyEnc = keyParams.getEncoded();
            if (keyEnc.length > publicSeed.length + root.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmss);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(keyEnc));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(keyParams.getParameters().getHeight(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSPublicKey(publicSeed, root));
        }
        if (publicKey instanceof XMSSMTPublicKeyParameters) {
            XMSSMTPublicKeyParameters keyParams = (XMSSMTPublicKeyParameters)publicKey;
            byte[] publicSeed = keyParams.getPublicSeed();
            byte[] root = keyParams.getRoot();
            byte[] keyEnc = keyParams.getEncoded();
            if (keyEnc.length > publicSeed.length + root.length) {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(IsaraObjectIdentifiers.id_alg_xmssmt);
                return new SubjectPublicKeyInfo(algorithmIdentifier, new DEROctetString(keyEnc));
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss_mt, new XMSSMTKeyParams(keyParams.getParameters().getHeight(), keyParams.getParameters().getLayers(), Utils.xmssLookupTreeAlgID(keyParams.getTreeDigest())));
            return new SubjectPublicKeyInfo(algorithmIdentifier, new XMSSMTPublicKey(keyParams.getPublicSeed(), keyParams.getRoot()));
        }
        throw new IOException("key parameters not recognized");
    }
}

