/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmc.test;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartID;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartList;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.BodyPartPath;
import net.savignano.thirdparty.org.bouncycastle.asn1.cmc.ModCertTemplate;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.CertTemplate;
import net.savignano.thirdparty.org.bouncycastle.util.test.SimpleTest;

public class ModCertTemplateTest
extends SimpleTest {
    public static void main(String[] args) {
        ModCertTemplateTest.runTest(new ModCertTemplateTest());
    }

    public String getName() {
        return "ModCertTemplateTest";
    }

    public void performTest() throws Exception {
        BodyPartPath pkiDataReference = new BodyPartPath(new BodyPartID(10L));
        BodyPartList certReferences = new BodyPartList(new BodyPartID(12L));
        boolean replace = false;
        CertTemplate certTemplate = CertTemplate.getInstance(new DLSequence(new DERTaggedObject(false, 1, (ASN1Encodable)new ASN1Integer(34L))));
        ModCertTemplate modCertTemplate = new ModCertTemplate(pkiDataReference, certReferences, replace, certTemplate);
        byte[] b = modCertTemplate.getEncoded();
        ModCertTemplate modCertTemplateResult = ModCertTemplate.getInstance(b);
        this.isEquals("pkiDataReference", modCertTemplate.getPkiDataReference(), modCertTemplateResult.getPkiDataReference());
        this.isEquals("certReference", modCertTemplate.getCertReferences(), modCertTemplateResult.getCertReferences());
        this.isEquals("replacingFields", modCertTemplate.isReplacingFields(), modCertTemplateResult.isReplacingFields());
        this.isEquals("certTemplate", modCertTemplate.getCertTemplate().getSerialNumber(), modCertTemplateResult.getCertTemplate().getSerialNumber());
        ModCertTemplate mct = ModCertTemplate.getInstance(new DERSequence(new ASN1Encodable[]{pkiDataReference, certReferences, certTemplate}));
        this.isEquals("pkiDataReference", mct.getPkiDataReference(), pkiDataReference);
        this.isEquals("certReference", mct.getCertReferences(), certReferences);
        this.isEquals("DEFAULT TRUE on replacingFields", mct.isReplacingFields(), true);
        this.isEquals("certTemplate", mct.getCertTemplate().getSerialNumber(), certTemplate.getSerialNumber());
        try {
            ModCertTemplate.getInstance(new DERSequence());
            this.fail("Sequence must be 3 or 4.");
        }
        catch (Throwable t) {
            this.isEquals(t.getClass(), IllegalArgumentException.class);
        }
    }
}

