/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class UserIDPacket
extends ContainedPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        this.idData = in.readAll();
    }

    public UserIDPacket(String id) {
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public UserIDPacket(byte[] rawID) {
        this.idData = Arrays.clone(rawID);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object o) {
        if (o instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)o).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(13, this.idData);
    }
}

