/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.KEKIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.AuthAttributesProvider;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSecureReadable;
import net.savignano.thirdparty.org.bouncycastle.cms.KEKRecipient;
import net.savignano.thirdparty.org.bouncycastle.cms.KEKRecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.Recipient;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

