/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its.jcajce;

import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.BasePublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccCurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP384CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SymmAlgorithm;

public class JceITSPublicEncryptionKey
extends ITSPublicEncryptionKey {
    private final JcaJceHelper helper;

    JceITSPublicEncryptionKey(PublicEncryptionKey encryptionKey, JcaJceHelper helper) {
        super(encryptionKey);
        this.helper = helper;
    }

    JceITSPublicEncryptionKey(PublicKey encryptionKey, JcaJceHelper helper) {
        super(JceITSPublicEncryptionKey.fromPublicKey(encryptionKey));
        this.helper = helper;
    }

    static PublicEncryptionKey fromPublicKey(PublicKey key) {
        if (!(key instanceof ECPublicKey)) {
            throw new IllegalArgumentException("must be ECPublicKey instance");
        }
        ECPublicKey pKey = (ECPublicKey)key;
        ASN1ObjectIdentifier curveID = ASN1ObjectIdentifier.getInstance(SubjectPublicKeyInfo.getInstance(key.getEncoded()).getAlgorithm().getParameters());
        if (curveID.equals(SECObjectIdentifiers.secp256r1)) {
            return new PublicEncryptionKey(SymmAlgorithm.aes128Ccm, new BasePublicEncryptionKey.Builder().setChoice(0).setValue(EccP256CurvePoint.builder().createUncompressedP256(pKey.getW().getAffineX(), pKey.getW().getAffineY())).createBasePublicEncryptionKey());
        }
        if (curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            return new PublicEncryptionKey(SymmAlgorithm.aes128Ccm, new BasePublicEncryptionKey.Builder().setChoice(1).setValue(EccP256CurvePoint.builder().createUncompressedP256(pKey.getW().getAffineX(), pKey.getW().getAffineY())).createBasePublicEncryptionKey());
        }
        throw new IllegalArgumentException("unknown curve in public encryption key");
    }

    public PublicKey getKey() {
        byte[] key;
        X9ECParameters params;
        BasePublicEncryptionKey baseKey = this.encryptionKey.getBasePublicEncryptionKey();
        switch (baseKey.getChoice()) {
            case 0: {
                params = NISTNamedCurves.getByOID(SECObjectIdentifiers.secp256r1);
                break;
            }
            case 1: {
                params = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP256r1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        ASN1Encodable pviCurvePoint = this.encryptionKey.getBasePublicEncryptionKey().getValue();
        if (!(pviCurvePoint instanceof EccCurvePoint)) {
            throw new IllegalStateException("extension to public verification key not supported");
        }
        EccCurvePoint itsPoint = (EccCurvePoint)baseKey.getValue();
        ECCurve curve = params.getCurve();
        if (itsPoint instanceof EccP256CurvePoint) {
            key = itsPoint.getEncodedPoint();
        } else if (itsPoint instanceof EccP384CurvePoint) {
            key = itsPoint.getEncodedPoint();
        } else {
            throw new IllegalStateException("unknown key type");
        }
        ECPoint point = curve.decodePoint(key).normalize();
        try {
            KeyFactory keyFactory = this.helper.createKeyFactory("EC");
            ECParameterSpec spec = EC5Util.convertToSpec(params);
            java.security.spec.ECPoint jPoint = EC5Util.convertPoint(point);
            return keyFactory.generatePublic(new ECPublicKeySpec(jPoint, spec));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static class Builder {
        private JcaJceHelper helper = new DefaultJcaJceHelper();

        public Builder setProvider(Provider provider) {
            this.helper = new ProviderJcaJceHelper(provider);
            return this;
        }

        public Builder setProvider(String providerName) {
            this.helper = new NamedJcaJceHelper(providerName);
            return this;
        }

        public JceITSPublicEncryptionKey build(PublicEncryptionKey encryptionKey) {
            return new JceITSPublicEncryptionKey(encryptionKey, this.helper);
        }

        public JceITSPublicEncryptionKey build(PublicKey encryptionKey) {
            return new JceITSPublicEncryptionKey(encryptionKey, this.helper);
        }
    }
}

