/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jsse.provider;

import java.util.List;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import net.savignano.thirdparty.org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.NamedGroupInfo;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ProvSSLParameters;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import net.savignano.thirdparty.org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ContextData {
    private final ProvSSLContextSpi context;
    private final JcaTlsCrypto crypto;
    private final BCX509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final NamedGroupInfo.PerContext namedGroups;
    private final SignatureSchemeInfo.PerContext signatureSchemes;

    ContextData(ProvSSLContextSpi context, JcaTlsCrypto crypto, BCX509ExtendedKeyManager x509KeyManager, BCX509ExtendedTrustManager x509TrustManager) {
        this.context = context;
        this.crypto = crypto;
        this.x509KeyManager = x509KeyManager;
        this.x509TrustManager = x509TrustManager;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.namedGroups = NamedGroupInfo.createPerContext(context.isFips(), crypto);
        this.signatureSchemes = SignatureSchemeInfo.createPerContext(context.isFips(), crypto, this.namedGroups);
    }

    NamedGroupInfo.PerConnection getNamedGroups(ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        return NamedGroupInfo.createPerConnection(this.namedGroups, sslParameters, activeProtocolVersions);
    }

    List<SignatureSchemeInfo> getActiveCertsSignatureSchemes(boolean isServer, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions, NamedGroupInfo.PerConnection namedGroups) {
        return SignatureSchemeInfo.getActiveCertsSignatureSchemes(this.signatureSchemes, isServer, sslParameters, activeProtocolVersions, namedGroups);
    }

    ProvSSLContextSpi getContext() {
        return this.context;
    }

    JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> sigAndHashAlgs) {
        return SignatureSchemeInfo.getSignatureSchemes(this.signatureSchemes, sigAndHashAlgs);
    }

    BCX509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }
}

