/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class CertificateBase
extends ASN1Object {
    private final ASN1Integer version;
    private final CertificateType type;
    private final IssuerIdentifier issuer;
    private final ToBeSignedCertificate toBeSignedCertificate;
    private final Signature signature;

    public CertificateBase(ASN1Integer version, CertificateType type, IssuerIdentifier issuer, ToBeSignedCertificate toBeSignedCertificate, Signature signature) {
        this.version = version;
        this.type = type;
        this.issuer = issuer;
        this.toBeSignedCertificate = toBeSignedCertificate;
        this.signature = signature;
    }

    public static CertificateBase getInstance(Object o) {
        if (o instanceof CertificateBase) {
            return (CertificateBase)o;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(o);
        ASN1Integer version = ASN1Integer.getInstance(seq.getObjectAt(0));
        CertificateType type = CertificateType.getInstance(seq.getObjectAt(1));
        IssuerIdentifier issuerIdentifier = IssuerIdentifier.getInstance(seq.getObjectAt(2));
        ToBeSignedCertificate cert = ToBeSignedCertificate.getInstance(seq.getObjectAt(3));
        Signature signature = OEROptional.getValue(Signature.class, seq.getObjectAt(4));
        return new Builder().setVersion(version).setType(type).setIssuer(issuerIdentifier).setToBeSignedCertificate(cert).setSignature(signature).createCertificateBase();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public CertificateType getType() {
        return this.type;
    }

    public IssuerIdentifier getIssuer() {
        return this.issuer;
    }

    public ToBeSignedCertificate getToBeSignedCertificate() {
        return this.toBeSignedCertificate;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.version, this.type, this.issuer, this.toBeSignedCertificate, OEROptional.getInstance(this.signature));
    }

    public static class Builder {
        private ASN1Integer version;
        private CertificateType type;
        private IssuerIdentifier issuer;
        private ToBeSignedCertificate toBeSignedCertificate;
        private Signature signature;

        public Builder setVersion(ASN1Integer version) {
            this.version = version;
            return this;
        }

        public Builder setType(CertificateType type) {
            this.type = type;
            return this;
        }

        public Builder setIssuer(IssuerIdentifier issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder setToBeSignedCertificate(ToBeSignedCertificate toBeSignedCertificate) {
            this.toBeSignedCertificate = toBeSignedCertificate;
            return this;
        }

        public Builder setSignature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public CertificateBase createCertificateBase() {
            return new CertificateBase(this.version, this.type, this.issuer, this.toBeSignedCertificate, this.signature);
        }
    }
}

