/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EtsiOriginatingHeaderInfoExtension;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HeaderInfoContributorId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributedExtensionBlock
extends ASN1Object {
    private final HeaderInfoContributorId contributorId;
    private final List<EtsiOriginatingHeaderInfoExtension> extns;

    public ContributedExtensionBlock(HeaderInfoContributorId contributorId, List<EtsiOriginatingHeaderInfoExtension> extns) {
        this.contributorId = contributorId;
        this.extns = extns;
    }

    public static ContributedExtensionBlock getInstance(Object src) {
        if (src instanceof ContributedExtensionBlock) {
            return (ContributedExtensionBlock)src;
        }
        Iterator<ASN1Encodable> items = ASN1Sequence.getInstance(src).iterator();
        HeaderInfoContributorId id = HeaderInfoContributorId.getInstance(items.next());
        ArrayList<EtsiOriginatingHeaderInfoExtension> extns = new ArrayList<EtsiOriginatingHeaderInfoExtension>();
        while (items.hasNext()) {
            extns.add(EtsiOriginatingHeaderInfoExtension.getInstance(items.next()));
        }
        return new ContributedExtensionBlock(id, extns);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.contributorId, Utils.toSequence(this.extns));
    }

    public HeaderInfoContributorId getContributorId() {
        return this.contributorId;
    }

    public List<EtsiOriginatingHeaderInfoExtension> getExtns() {
        return this.extns;
    }
}

