/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Ieee1609Dot2Content;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Uint8;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

public class Ieee1609Dot2Data
extends ASN1Object {
    private final Uint8 protocolVersion;
    private final Ieee1609Dot2Content content;

    public Ieee1609Dot2Data(Uint8 protocolVersion, Ieee1609Dot2Content content) {
        this.protocolVersion = protocolVersion;
        this.content = content;
    }

    public static Ieee1609Dot2Data getInstance(Object src) {
        if (src instanceof Ieee1609Dot2Data) {
            return (Ieee1609Dot2Data)src;
        }
        Iterator<ASN1Encodable> items = ASN1Sequence.getInstance(src).iterator();
        return new Ieee1609Dot2Data(Uint8.getInstance(items.next()), Ieee1609Dot2Content.getInstance(items.next()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.protocolVersion, this.content);
    }

    public Uint8 getProtocolVersion() {
        return this.protocolVersion;
    }

    public Ieee1609Dot2Content getContent() {
        return this.content;
    }

    public static class Builder {
        private Uint8 protocolVersion;
        private Ieee1609Dot2Content content;

        public Builder setProtocolVersion(Uint8 protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder setContent(Ieee1609Dot2Content content) {
            this.content = content;
            return this;
        }

        public Ieee1609Dot2Data build() {
            return new Ieee1609Dot2Data(this.protocolVersion, this.content);
        }
    }
}

