/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;

public class IssuerIdentifier
extends ASN1Object
implements ASN1Choice {
    public static final int sha256AndDigest = 0;
    public static final int self = 1;
    public static final int extension = 2;
    public static final int sha384AndDigest = 3;
    private final int choice;
    private final ASN1Encodable value;

    public IssuerIdentifier(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.value = value;
    }

    public static IssuerIdentifier getInstance(Object choice) {
        if (choice instanceof IssuerIdentifier) {
            return (IssuerIdentifier)choice;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(choice);
        int item = taggedObject.getTagNo();
        switch (item) {
            case 0: {
                return new IssuerIdentifier(0, HashedId.HashedId8.getInstance(taggedObject.getObject()));
            }
            case 1: {
                return new IssuerIdentifier(1, HashAlgorithm.getInstance(taggedObject.getObject()));
            }
            case 2: {
                return new IssuerIdentifier(2, DEROctetString.getInstance(taggedObject.getObject()));
            }
            case 3: {
                return new IssuerIdentifier(3, HashedId.HashedId8.getInstance(taggedObject.getObject()));
            }
        }
        throw new IllegalArgumentException("unable to decode into known choice" + item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isSelf() {
        return this.choice == 1;
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.value);
    }

    public static class Builder {
        public int choice;
        public ASN1Encodable value;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setValue(ASN1Encodable value) {
            this.value = value;
            return this;
        }

        public Builder sha256AndDigest(HashedId id) {
            this.choice = 0;
            this.value = id;
            return this;
        }

        public Builder self(HashAlgorithm alg) {
            this.choice = 1;
            this.value = alg;
            return this;
        }

        public Builder extension(byte[] ext) {
            this.choice = 2;
            this.value = new DEROctetString(ext);
            return this;
        }

        public Builder sha384AndDigest(HashedId id) {
            this.choice = 3;
            this.value = id;
            return this;
        }

        public IssuerIdentifier createIssuerIdentifier() {
            return new IssuerIdentifier(this.choice, this.value);
        }
    }
}

