/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccCurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP384CurvePoint;

public class PublicVerificationKey
extends ASN1Object
implements ASN1Choice {
    public static final int ecdsaNistP256 = 0;
    public static final int ecdsaBrainpoolP256r1 = 1;
    public static final int extension = 2;
    public static final int ecdsaBrainpoolP384r1 = 3;
    final int choice;
    final ASN1Encodable curvePoint;

    public PublicVerificationKey(int choice, ASN1Encodable curvePoint) {
        this.choice = choice;
        this.curvePoint = curvePoint;
    }

    public static PublicVerificationKey getInstance(Object object) {
        ASN1Object point;
        if (object instanceof PublicVerificationKey) {
            return (PublicVerificationKey)object;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(object);
        switch (taggedObject.getTagNo()) {
            case 0: 
            case 1: {
                point = EccP256CurvePoint.getInstance(taggedObject.getObject());
                break;
            }
            case 2: {
                point = DEROctetString.getInstance(taggedObject.getObject());
                break;
            }
            case 3: {
                point = EccP384CurvePoint.getInstance(taggedObject.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag value " + taggedObject.getTagNo());
            }
        }
        return new PublicVerificationKey(taggedObject.getTagNo(), point);
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getCurvePoint() {
        return this.curvePoint;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.curvePoint);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable curvePoint;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setCurvePoint(EccCurvePoint curvePoint) {
            this.curvePoint = curvePoint;
            return this;
        }

        public Builder ecdsaNistP256(EccP256CurvePoint point) {
            this.curvePoint = point;
            return this;
        }

        public Builder ecdsaBrainpoolP256r1(EccP256CurvePoint point) {
            this.curvePoint = point;
            return this;
        }

        public Builder ecdsaBrainpoolP384r1(EccP384CurvePoint point) {
            this.curvePoint = point;
            return this;
        }

        public Builder extension(byte[] value) {
            this.curvePoint = new DEROctetString(value);
            return this;
        }

        public PublicVerificationKey createPublicVerificationKey() {
            return new PublicVerificationKey(this.choice, this.curvePoint);
        }
    }
}

