/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RegionInterface;
import net.savignano.thirdparty.org.bouncycastle.oer.its.TwoDLocation;

public class RectangularRegion
extends ASN1Object
implements RegionInterface {
    private final TwoDLocation northWest;
    private final TwoDLocation southEast;

    public RectangularRegion(TwoDLocation northWest, TwoDLocation southEast) {
        this.northWest = northWest;
        this.southEast = southEast;
    }

    public static RectangularRegion getInstance(Object o) {
        if (o instanceof RectangularRegion) {
            return (RectangularRegion)o;
        }
        ASN1Sequence seg = ASN1Sequence.getInstance(o);
        return new RectangularRegion(TwoDLocation.getInstance(seg.getObjectAt(0)), TwoDLocation.getInstance(seg.getObjectAt(1)));
    }

    public TwoDLocation getNorthWest() {
        return this.northWest;
    }

    public TwoDLocation getSouthEast() {
        return this.southEast;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{this.northWest, this.southEast});
    }
}

