/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Region;
import net.savignano.thirdparty.org.bouncycastle.oer.its.RegionInterface;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Uint16;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionAndSubregions
extends ASN1Object
implements RegionInterface {
    private final Region region;
    private final List<Uint16> subRegions;

    public RegionAndSubregions(Region region, List<Uint16> subRegions) {
        this.region = region;
        this.subRegions = Collections.unmodifiableList(subRegions);
    }

    public static RegionAndSubregions getInstance(Object o) {
        if (o instanceof RegionAndSubregions) {
            return (RegionAndSubregions)o;
        }
        ASN1Sequence seq = ASN1Sequence.getInstance(0);
        Builder builder = new Builder();
        builder.setRegion(Region.getInstance(seq.getObjectAt(0)));
        ASN1Sequence subRegionsSeq = ASN1Sequence.getInstance(seq.getObjectAt(1));
        Iterator<ASN1Encodable> it = subRegionsSeq.iterator();
        while (it.hasNext()) {
            builder.setSubRegion(Uint16.getInstance(it.next()));
        }
        return builder.createRegionAndSubregions();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.region, Utils.toSequence(this.subRegions));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private Region region;
        private List<Uint16> subRegions;

        public Builder setRegion(Region region) {
            this.region = region;
            return this;
        }

        public Builder setSubRegions(List<Uint16> subRegions) {
            this.subRegions = subRegions;
            return this;
        }

        public Builder setSubRegion(Uint16 ... subRegions) {
            this.subRegions.addAll(Arrays.asList(subRegions));
            return this;
        }

        public RegionAndSubregions createRegionAndSubregions() {
            return new RegionAndSubregions(this.region, this.subRegions);
        }
    }
}

