/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.BitmapSsp;

public class ServiceSpecificPermissions
extends ASN1Object
implements ASN1Choice {
    public static final int opaque = 0;
    public static final int extension = 1;
    public static final int bitmapSsp = 2;
    private final int choice;
    private final ASN1Encodable object;

    public ServiceSpecificPermissions(int choice, ASN1Encodable object) {
        this.choice = choice;
        this.object = object;
    }

    public static ServiceSpecificPermissions getInstance(Object o) {
        if (o instanceof ServiceSpecificPermissions) {
            return (ServiceSpecificPermissions)o;
        }
        ASN1TaggedObject dto = ASN1TaggedObject.getInstance(o);
        switch (dto.getTagNo()) {
            case 0: 
            case 1: {
                return new ServiceSpecificPermissions(dto.getTagNo(), DEROctetString.getInstance(dto.getObject()));
            }
            case 2: {
                return new ServiceSpecificPermissions(dto.getTagNo(), BitmapSsp.getInstance(dto.getObject()));
            }
        }
        throw new IllegalArgumentException("unknown choice " + dto.getTagNo());
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getObject() {
        return this.object;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.object);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable object;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setObject(ASN1Encodable object) {
            this.object = object;
            return this;
        }

        public Builder opaque() {
            return this.setChoice(0);
        }

        public Builder extension(byte[] data) {
            return this.setChoice(2).setObject(new DEROctetString(data));
        }

        public Builder bitmapSsp(ASN1OctetString octetString) {
            return this.setChoice(2).setObject(octetString);
        }

        public ServiceSpecificPermissions createServiceSpecificPermissions() {
            return new ServiceSpecificPermissions(this.choice, this.object);
        }
    }
}

