/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import java.util.Iterator;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Null;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CertificateId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.CrlSeries;
import net.savignano.thirdparty.org.bouncycastle.oer.its.GeographicRegion;
import net.savignano.thirdparty.org.bouncycastle.oer.its.HashedId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfPsidGroupPermissions;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SequenceOfPsidSsp;
import net.savignano.thirdparty.org.bouncycastle.oer.its.SubjectAssurance;
import net.savignano.thirdparty.org.bouncycastle.oer.its.Utils;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ValidityPeriod;
import net.savignano.thirdparty.org.bouncycastle.oer.its.VerificationKeyIndicator;

public class ToBeSignedCertificate
extends ASN1Object {
    private final CertificateId certificateId;
    private final HashedId cracaId;
    private final CrlSeries crlSeries;
    private final ValidityPeriod validityPeriod;
    private final GeographicRegion geographicRegion;
    private final SubjectAssurance assuranceLevel;
    private final SequenceOfPsidSsp appPermissions;
    private final SequenceOfPsidGroupPermissions certIssuePermissions;
    private final SequenceOfPsidGroupPermissions certRequestPermissions;
    private final ASN1Null canRequestRollover;
    private final PublicEncryptionKey encryptionKey;
    private final VerificationKeyIndicator verificationKeyIndicator;

    public ToBeSignedCertificate(CertificateId certificateId, HashedId cracaId, CrlSeries crlSeries, ValidityPeriod validityPeriod, GeographicRegion geographicRegion, SubjectAssurance assuranceLevel, SequenceOfPsidSsp appPermissions, SequenceOfPsidGroupPermissions certIssuePermissions, SequenceOfPsidGroupPermissions certRequestPermissions, ASN1Null canRequestRollover, PublicEncryptionKey encryptionKey, VerificationKeyIndicator verificationKeyIndicator) {
        this.certificateId = certificateId;
        this.cracaId = cracaId;
        this.crlSeries = crlSeries;
        this.validityPeriod = validityPeriod;
        this.geographicRegion = geographicRegion;
        this.assuranceLevel = assuranceLevel;
        this.appPermissions = appPermissions;
        this.certIssuePermissions = certIssuePermissions;
        this.certRequestPermissions = certRequestPermissions;
        this.canRequestRollover = canRequestRollover;
        this.encryptionKey = encryptionKey;
        this.verificationKeyIndicator = verificationKeyIndicator;
    }

    public static ToBeSignedCertificate getInstance(Object o) {
        if (o == null || o instanceof ToBeSignedCertificate) {
            return (ToBeSignedCertificate)o;
        }
        Iterator<ASN1Encodable> seq = ASN1Sequence.getInstance(o).iterator();
        return new Builder().setCertificateId(CertificateId.getInstance(seq.next())).setCracaId(HashedId.getInstance(seq.next())).setCrlSeries(CrlSeries.getInstance(seq.next())).setValidityPeriod(ValidityPeriod.getInstance(seq.next())).setGeographicRegion(OEROptional.getValue(GeographicRegion.class, seq.next())).setAssuranceLevel(OEROptional.getValue(SubjectAssurance.class, seq.next())).setAppPermissions(OEROptional.getValue(SequenceOfPsidSsp.class, seq.next())).setCertIssuePermissions(OEROptional.getValue(SequenceOfPsidGroupPermissions.class, seq.next())).setCertRequestPermissions(OEROptional.getValue(SequenceOfPsidGroupPermissions.class, seq.next())).setCanRequestRollover(OEROptional.getValue(ASN1Null.class, seq.next())).setEncryptionKey(OEROptional.getValue(PublicEncryptionKey.class, seq.next())).setVerificationKeyIndicator(VerificationKeyIndicator.getInstance(seq.next())).createToBeSignedCertificate();
    }

    public CertificateId getCertificateId() {
        return this.certificateId;
    }

    public HashedId getCracaId() {
        return this.cracaId;
    }

    public CrlSeries getCrlSeries() {
        return this.crlSeries;
    }

    public ValidityPeriod getValidityPeriod() {
        return this.validityPeriod;
    }

    public GeographicRegion getGeographicRegion() {
        return this.geographicRegion;
    }

    public SubjectAssurance getAssuranceLevel() {
        return this.assuranceLevel;
    }

    public SequenceOfPsidSsp getAppPermissions() {
        return this.appPermissions;
    }

    public SequenceOfPsidGroupPermissions getCertIssuePermissions() {
        return this.certIssuePermissions;
    }

    public SequenceOfPsidGroupPermissions getCertRequestPermissions() {
        return this.certRequestPermissions;
    }

    public ASN1Null getCanRequestRollover() {
        return this.canRequestRollover;
    }

    public PublicEncryptionKey getEncryptionKey() {
        return this.encryptionKey;
    }

    public VerificationKeyIndicator getVerificationKeyIndicator() {
        return this.verificationKeyIndicator;
    }

    public ASN1Primitive toASN1Primitive() {
        return Utils.toSequence(this.certificateId, this.cracaId, this.crlSeries, this.validityPeriod, OEROptional.getInstance(this.geographicRegion), OEROptional.getInstance(this.assuranceLevel), OEROptional.getInstance(this.appPermissions), OEROptional.getInstance(this.certIssuePermissions), OEROptional.getInstance(this.certRequestPermissions), OEROptional.getInstance(this.canRequestRollover), OEROptional.getInstance(this.encryptionKey), this.verificationKeyIndicator);
    }

    public static class Builder {
        private CertificateId certificateId;
        private HashedId cracaId;
        private CrlSeries crlSeries;
        private ValidityPeriod validityPeriod;
        private GeographicRegion geographicRegion;
        private SubjectAssurance assuranceLevel;
        private SequenceOfPsidSsp appPermissions;
        private SequenceOfPsidGroupPermissions certIssuePermissions;
        private SequenceOfPsidGroupPermissions certRequestPermissions;
        private ASN1Null canRequestRollover;
        private PublicEncryptionKey encryptionKey;
        private VerificationKeyIndicator verificationKeyIndicator;

        public Builder() {
        }

        public Builder(Builder o) {
            this.certificateId = o.certificateId;
            this.cracaId = o.cracaId;
            this.crlSeries = o.crlSeries;
            this.validityPeriod = o.validityPeriod;
            this.geographicRegion = o.geographicRegion;
            this.assuranceLevel = o.assuranceLevel;
            this.appPermissions = o.appPermissions;
            this.certIssuePermissions = o.certIssuePermissions;
            this.certRequestPermissions = o.certRequestPermissions;
            this.canRequestRollover = o.canRequestRollover;
            this.encryptionKey = o.encryptionKey;
            this.verificationKeyIndicator = o.verificationKeyIndicator;
        }

        public Builder(ToBeSignedCertificate o) {
            this.certificateId = o.certificateId;
            this.cracaId = o.cracaId;
            this.crlSeries = o.crlSeries;
            this.validityPeriod = o.validityPeriod;
            this.geographicRegion = o.geographicRegion;
            this.assuranceLevel = o.assuranceLevel;
            this.appPermissions = o.appPermissions;
            this.certIssuePermissions = o.certIssuePermissions;
            this.certRequestPermissions = o.certRequestPermissions;
            this.canRequestRollover = o.canRequestRollover;
            this.encryptionKey = o.encryptionKey;
            this.verificationKeyIndicator = o.verificationKeyIndicator;
        }

        public Builder setCertificateId(CertificateId certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder setCracaId(HashedId cracaId) {
            this.cracaId = cracaId;
            return this;
        }

        public Builder setCrlSeries(CrlSeries crlSeries) {
            this.crlSeries = crlSeries;
            return this;
        }

        public Builder setValidityPeriod(ValidityPeriod validityPeriod) {
            this.validityPeriod = validityPeriod;
            return this;
        }

        public Builder setGeographicRegion(GeographicRegion geographicRegion) {
            this.geographicRegion = geographicRegion;
            return this;
        }

        public Builder setAssuranceLevel(SubjectAssurance assuranceLevel) {
            this.assuranceLevel = assuranceLevel;
            return this;
        }

        public Builder setAppPermissions(SequenceOfPsidSsp appPermissions) {
            this.appPermissions = appPermissions;
            return this;
        }

        public Builder setCertIssuePermissions(SequenceOfPsidGroupPermissions certIssuePermissions) {
            this.certIssuePermissions = certIssuePermissions;
            return this;
        }

        public Builder setCertRequestPermissions(SequenceOfPsidGroupPermissions certRequestPermissions) {
            this.certRequestPermissions = certRequestPermissions;
            return this;
        }

        public Builder setCanRequestRollover(ASN1Null canRequestRollover) {
            this.canRequestRollover = canRequestRollover;
            return this;
        }

        public Builder setEncryptionKey(PublicEncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder setVerificationKeyIndicator(VerificationKeyIndicator verificationKeyIndicator) {
            this.verificationKeyIndicator = verificationKeyIndicator;
            return this;
        }

        public ToBeSignedCertificate createToBeSignedCertificate() {
            return new ToBeSignedCertificate(this.certificateId, this.cracaId, this.crlSeries, this.validityPeriod, this.geographicRegion, this.assuranceLevel, this.appPermissions, this.certIssuePermissions, this.certRequestPermissions, this.canRequestRollover, this.encryptionKey, this.verificationKeyIndicator);
        }
    }
}

