/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.EccP256CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.PublicVerificationKey;

public class VerificationKeyIndicator
extends ASN1Object
implements ASN1Choice {
    public static final int verificationKey = 0;
    public static final int reconstructionValue = 1;
    public static final int extension = 2;
    private final int choice;
    private final ASN1Encodable object;

    public VerificationKeyIndicator(int choice, ASN1Encodable object) {
        this.choice = choice;
        this.object = object;
    }

    public static VerificationKeyIndicator getInstance(Object objectAt) {
        if (objectAt instanceof VerificationKeyIndicator) {
            return (VerificationKeyIndicator)objectAt;
        }
        ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(objectAt);
        switch (taggedObject.getTagNo()) {
            case 0: {
                return new Builder().setChoice(0).setObject(PublicVerificationKey.getInstance(taggedObject.getObject())).createVerificationKeyIndicator();
            }
            case 1: {
                return new Builder().setChoice(1).setObject(EccP256CurvePoint.getInstance(taggedObject.getObject())).createVerificationKeyIndicator();
            }
            case 2: {
                return new VerificationKeyIndicator(2, DEROctetString.getInstance(taggedObject.getLoadedObject()));
            }
        }
        throw new IllegalArgumentException("unhandled tag " + taggedObject.getTagNo());
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getObject() {
        return this.object;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.object);
    }

    public static class Builder {
        private int choice;
        private ASN1Encodable object;

        public Builder setChoice(int choice) {
            this.choice = choice;
            return this;
        }

        public Builder setObject(ASN1Encodable object) {
            this.object = object;
            return this;
        }

        public Builder publicVerificationKey(PublicVerificationKey publicVerificationKey) {
            this.object = publicVerificationKey;
            this.choice = 0;
            return this;
        }

        public Builder reconstructionValue(EccP256CurvePoint curvePoint) {
            this.object = curvePoint;
            this.choice = 1;
            return this;
        }

        public Builder extension(byte[] value) {
            this.object = new DEROctetString(value);
            this.choice = 2;
            return this;
        }

        public VerificationKeyIndicator createVerificationKeyIndicator() {
            return new VerificationKeyIndicator(this.choice, this.object);
        }
    }
}

