/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ECParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.ec.CustomNamedCurves;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECCurve;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

class JcaJcePGPUtil {
    JcaJcePGPUtil() {
    }

    public static SecretKey makeSymmetricKey(int algorithm, byte[] keyBytes) throws PGPException {
        String algName = PGPUtil.getSymmetricCipherName(algorithm);
        if (algName == null) {
            throw new PGPException("unknown symmetric algorithm: " + algorithm);
        }
        return new SecretKeySpec(keyBytes, algName);
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) throws IOException {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray(encodedPoint));
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9Params = CustomNamedCurves.getByOID(curveOID);
        if (x9Params == null) {
            return ECNamedCurveTable.getByOID(curveOID);
        }
        return x9Params;
    }
}

