/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.SecurityParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsContext;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsPeer;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsSession;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsNonceGenerator;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;
import net.savignano.thirdparty.org.bouncycastle.util.Times;

abstract class AbstractTlsContext
implements TlsContext {
    private static long counter = Times.nanoTime();
    private TlsCrypto crypto;
    private int connectionEnd;
    private TlsNonceGenerator nonceGenerator;
    private SecurityParameters securityParametersHandshake = null;
    private SecurityParameters securityParametersConnection = null;
    private ProtocolVersion[] clientSupportedVersions = null;
    private ProtocolVersion clientVersion = null;
    private ProtocolVersion rsaPreMasterSecretVersion = null;
    private TlsSession session = null;
    private Object userObject = null;

    private static synchronized long nextCounterValue() {
        return ++counter;
    }

    private static TlsNonceGenerator createNonceGenerator(TlsCrypto crypto, int connectionEnd) {
        byte[] additionalSeedMaterial = new byte[16];
        Pack.longToBigEndian(AbstractTlsContext.nextCounterValue(), additionalSeedMaterial, 0);
        Pack.longToBigEndian(Times.nanoTime(), additionalSeedMaterial, 8);
        additionalSeedMaterial[0] = (byte)(additionalSeedMaterial[0] & 0x7F);
        additionalSeedMaterial[0] = (byte)(additionalSeedMaterial[0] | (byte)(connectionEnd << 7));
        return crypto.createNonceGenerator(additionalSeedMaterial);
    }

    AbstractTlsContext(TlsCrypto crypto, int connectionEnd) {
        this.crypto = crypto;
        this.connectionEnd = connectionEnd;
        this.nonceGenerator = AbstractTlsContext.createNonceGenerator(crypto, connectionEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handshakeBeginning(TlsPeer peer) throws IOException {
        AbstractTlsContext abstractTlsContext = this;
        synchronized (abstractTlsContext) {
            if (null != this.securityParametersHandshake) {
                throw new TlsFatalAlert(80, "Handshake already started");
            }
            this.securityParametersHandshake = new SecurityParameters();
            this.securityParametersHandshake.entity = this.connectionEnd;
            if (null != this.securityParametersConnection) {
                this.securityParametersHandshake.renegotiating = true;
                this.securityParametersHandshake.secureRenegotiation = this.securityParametersConnection.isSecureRenegotiation();
                this.securityParametersHandshake.negotiatedVersion = this.securityParametersConnection.getNegotiatedVersion();
            }
        }
        peer.notifyHandshakeBeginning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handshakeComplete(TlsPeer peer, TlsSession session) throws IOException {
        AbstractTlsContext abstractTlsContext = this;
        synchronized (abstractTlsContext) {
            if (null == this.securityParametersHandshake) {
                throw new TlsFatalAlert(80);
            }
            this.session = session;
            this.securityParametersConnection = this.securityParametersHandshake;
            this.securityParametersHandshake = null;
        }
        peer.notifyHandshakeComplete();
    }

    synchronized boolean isConnected() {
        return null != this.securityParametersConnection;
    }

    synchronized boolean isHandshaking() {
        return null != this.securityParametersHandshake;
    }

    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    public TlsNonceGenerator getNonceGenerator() {
        return this.nonceGenerator;
    }

    public synchronized SecurityParameters getSecurityParameters() {
        return null != this.securityParametersHandshake ? this.securityParametersHandshake : this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersConnection() {
        return this.securityParametersConnection;
    }

    public synchronized SecurityParameters getSecurityParametersHandshake() {
        return this.securityParametersHandshake;
    }

    public ProtocolVersion[] getClientSupportedVersions() {
        return this.clientSupportedVersions;
    }

    void setClientSupportedVersions(ProtocolVersion[] clientSupportedVersions) {
        this.clientSupportedVersions = clientSupportedVersions;
    }

    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    void setClientVersion(ProtocolVersion clientVersion) {
        this.clientVersion = clientVersion;
    }

    public ProtocolVersion getRSAPreMasterSecretVersion() {
        return this.rsaPreMasterSecretVersion;
    }

    void setRSAPreMasterSecretVersion(ProtocolVersion rsaPreMasterSecretVersion) {
        this.rsaPreMasterSecretVersion = rsaPreMasterSecretVersion;
    }

    public ProtocolVersion getServerVersion() {
        return this.getSecurityParameters().getNegotiatedVersion();
    }

    public TlsSession getResumableSession() {
        TlsSession session = this.getSession();
        if (session == null || !session.isResumable()) {
            return null;
        }
        return session;
    }

    public TlsSession getSession() {
        return this.session;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public byte[] exportChannelBinding(int channelBinding) {
        SecurityParameters securityParameters = this.getSecurityParametersConnection();
        if (null == securityParameters) {
            throw new IllegalStateException("Export of channel bindings unavailable before handshake completion");
        }
        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            return null;
        }
        switch (channelBinding) {
            case 0: {
                byte[] tlsServerEndPoint = securityParameters.getTLSServerEndPoint();
                return TlsUtils.isNullOrEmpty(tlsServerEndPoint) ? null : Arrays.clone(tlsServerEndPoint);
            }
            case 1: {
                return Arrays.clone(securityParameters.getTLSUnique());
            }
        }
        throw new UnsupportedOperationException();
    }

    public byte[] exportEarlyKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters sp = this.getSecurityParametersHandshake();
        if (null == sp) {
            throw new IllegalStateException("Export of early key material only available during handshake");
        }
        return this.exportKeyingMaterial13(this.checkEarlyExportSecret(sp.getEarlyExporterMasterSecret()), sp.getPRFCryptoHashAlgorithm(), asciiLabel, context, length);
    }

    public byte[] exportKeyingMaterial(String asciiLabel, byte[] context, int length) {
        SecurityParameters sp = this.getSecurityParametersConnection();
        if (null == sp) {
            throw new IllegalStateException("Export of key material unavailable before handshake completion");
        }
        if (!sp.isExtendedMasterSecret()) {
            throw new IllegalStateException("Export of key material requires extended_master_secret");
        }
        if (TlsUtils.isTLSv13(sp.getNegotiatedVersion())) {
            return this.exportKeyingMaterial13(this.checkExportSecret(sp.getExporterMasterSecret()), sp.getPRFCryptoHashAlgorithm(), asciiLabel, context, length);
        }
        byte[] seed = TlsUtils.calculateExporterSeed(sp, context);
        return TlsUtils.PRF(sp, this.checkExportSecret(sp.getMasterSecret()), asciiLabel, seed, length).extract();
    }

    protected byte[] exportKeyingMaterial13(TlsSecret secret, int cryptoHashAlgorithm, String asciiLabel, byte[] context, int length) {
        if (null == context) {
            context = TlsUtils.EMPTY_BYTES;
        } else if (!TlsUtils.isValidUint16(context.length)) {
            throw new IllegalArgumentException("'context' must have length less than 2^16 (or be null)");
        }
        try {
            return TlsCryptoUtils.hkdfExpandLabel(secret, cryptoHashAlgorithm, asciiLabel, context, length).extract();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected TlsSecret checkEarlyExportSecret(TlsSecret secret) {
        if (null == secret) {
            throw new IllegalStateException("Export of early key material not available for this handshake");
        }
        return secret;
    }

    protected TlsSecret checkExportSecret(TlsSecret secret) {
        if (null == secret) {
            throw new IllegalStateException("Export of key material only available from notifyHandshakeComplete()");
        }
        return secret;
    }
}

