/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.math.BigInteger;
import java.util.Vector;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsDHGroupVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.DHGroup;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.DHStandardGroups;

public class DefaultTlsDHGroupVerifier
implements TlsDHGroupVerifier {
    public static final int DEFAULT_MINIMUM_PRIME_BITS = 2048;
    private static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;
    protected int minimumPrimeBits;

    private static void addDefaultGroup(DHGroup dhGroup) {
        DEFAULT_GROUPS.addElement(dhGroup);
    }

    public DefaultTlsDHGroupVerifier() {
        this(2048);
    }

    public DefaultTlsDHGroupVerifier(int minimumPrimeBits) {
        this(DEFAULT_GROUPS, minimumPrimeBits);
    }

    public DefaultTlsDHGroupVerifier(Vector groups, int minimumPrimeBits) {
        this.groups = new Vector(groups);
        this.minimumPrimeBits = minimumPrimeBits;
    }

    public boolean accept(DHGroup dhGroup) {
        return this.checkMinimumPrimeBits(dhGroup) && this.checkGroup(dhGroup);
    }

    public int getMinimumPrimeBits() {
        return this.minimumPrimeBits;
    }

    protected boolean areGroupsEqual(DHGroup a, DHGroup b) {
        return a == b || this.areParametersEqual(a.getP(), b.getP()) && this.areParametersEqual(a.getG(), b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    protected boolean checkGroup(DHGroup dhGroup) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(dhGroup, (DHGroup)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean checkMinimumPrimeBits(DHGroup dhGroup) {
        return dhGroup.getP().bitLength() >= this.getMinimumPrimeBits();
    }

    static {
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_2048);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_3072);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_4096);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_6144);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc3526_8192);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe2048);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe3072);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe4096);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe6144);
        DefaultTlsDHGroupVerifier.addDefaultGroup(DHStandardGroups.rfc7919_ffdhe8192);
    }
}

