/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;

public class KeyShareEntry {
    protected final int namedGroup;
    protected final byte[] keyExchange;

    private static boolean checkKeyExchangeLength(int length) {
        return 0 < length && length < 65536;
    }

    public KeyShareEntry(int namedGroup, byte[] keyExchange) {
        if (!TlsUtils.isValidUint16(namedGroup)) {
            throw new IllegalArgumentException("'namedGroup' should be a uint16");
        }
        if (null == keyExchange) {
            throw new NullPointerException("'keyExchange' cannot be null");
        }
        if (!KeyShareEntry.checkKeyExchangeLength(keyExchange.length)) {
            throw new IllegalArgumentException("'keyExchange' must have length from 1 to (2^16 - 1)");
        }
        this.namedGroup = namedGroup;
        this.keyExchange = keyExchange;
    }

    public int getNamedGroup() {
        return this.namedGroup;
    }

    public byte[] getKeyExchange() {
        return this.keyExchange;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint16(this.getNamedGroup(), output);
        TlsUtils.writeOpaque16(this.getKeyExchange(), output);
    }

    public static KeyShareEntry parse(InputStream input) throws IOException {
        int namedGroup = TlsUtils.readUint16(input);
        byte[] keyExchange = TlsUtils.readOpaque16(input, 1);
        return new KeyShareEntry(namedGroup, keyExchange);
    }
}

