/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.tls.AbstractTlsServer;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsCredentialedDecryptor;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsCredentials;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsPSKIdentityManager;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCrypto;

public class PSKTlsServer
extends AbstractTlsServer {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto);
        this.pskIdentityManager = pskIdentityManager;
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    public ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv12;
    }

    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsPSKIdentityManager getPSKIdentityManager() {
        return this.pskIdentityManager;
    }
}

